/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.QuadSplittingMode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPResult;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.UpdatedQuadsList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.FullTQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import org.joml.Vector3fc;

class BSPWorkspace
extends ObjectArrayList<TQuad> {
    final BSPResult result = new BSPResult();
    private final SectionPos sectionPos;
    final boolean prepareNodeReuse;
    final boolean quantizeTriggerNormals;
    private int quadCount;
    private final int maxQuadCount;
    private IntArrayList availableQuadIndexes;
    private UpdatedQuadsList updatedQuads;

    BSPWorkspace(TQuad[] quads, SectionPos sectionPos, boolean prepareNodeReuse, QuadSplittingMode quadSplittingMode) {
        super(quads);
        this.sectionPos = sectionPos;
        this.prepareNodeReuse = prepareNodeReuse;
        this.quantizeTriggerNormals = quadSplittingMode.quantizeTriggerNormals();
        this.quadCount = quads.length;
        this.maxQuadCount = quadSplittingMode.allowsSplitting() ? quadSplittingMode.getMaxTotalQuads(this.quadCount) : this.quadCount;
    }

    boolean canSplitQuads() {
        return this.quadCount < this.maxQuadCount;
    }

    void addAlignedPartitionPlane(int axis, float distance) {
        this.result.addDoubleSidedAlignedPlane(this.sectionPos, axis, distance);
    }

    void addUnalignedPartitionPlane(Vector3fc planeNormal, float distance) {
        this.result.addDoubleSidedUnalignedPlane(this.sectionPos, planeNormal, distance);
    }

    private void registerQuadUpdate(FullTQuad quad) {
        if (quad.triggerAndSetUpdatedVertices()) {
            if (this.updatedQuads == null) {
                this.updatedQuads = new UpdatedQuadsList();
            }
            this.updatedQuads.add(quad);
        }
    }

    public UpdatedQuadsList getFinalizedUpdatedQuads() {
        if (this.updatedQuads != null) {
            this.updatedQuads.setQuadCounts(this.size(), this.quadCount);
        }
        return this.updatedQuads;
    }

    int pushQuad(FullTQuad quad) {
        int index;
        if (quad == null || quad.isInvalid()) {
            return -1;
        }
        if (this.availableQuadIndexes == null || this.availableQuadIndexes.isEmpty()) {
            index = this.size();
            this.add(quad);
        } else {
            index = this.availableQuadIndexes.removeInt(this.availableQuadIndexes.size() - 1);
            this.set(index, quad);
        }
        quad.setWriteToIndex(index);
        ++this.quadCount;
        this.registerQuadUpdate(quad);
        return index;
    }

    int updateQuad(FullTQuad quad, int quadIndex) {
        if (quad == null) {
            return -1;
        }
        if (quad.isInvalid()) {
            int lastIndex = this.size() - 1;
            if (quadIndex == lastIndex) {
                this.remove(lastIndex);
            } else {
                this.set(quadIndex, null);
                if (this.availableQuadIndexes == null) {
                    this.availableQuadIndexes = new IntArrayList();
                }
                this.availableQuadIndexes.add(quadIndex);
            }
            quad.setNoWrite();
            this.registerQuadUpdate(quad);
            --this.quadCount;
            return -1;
        }
        quad.setWriteToIndex(quadIndex);
        this.registerQuadUpdate(quad);
        return quadIndex;
    }
}

