/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import net.caffeinemc.mods.sodium.client.render.chunk.tree.BaseForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.Tree;
import net.minecraft.class_1150;

public abstract class BaseBiForest<T extends Tree>
extends BaseForest<T> {
    private static final int SECONDARY_TREE_OFFSET_XZ = 4;
    protected final T mainTree;
    protected T secondaryTree;

    public BaseBiForest(int baseOffsetX, int baseOffsetY, int baseOffsetZ, float buildDistance) {
        super(baseOffsetX, baseOffsetY, baseOffsetZ, buildDistance);
        this.mainTree = this.makeTree(this.baseOffsetX, this.baseOffsetY, this.baseOffsetZ);
    }

    protected T makeSecondaryTree() {
        return this.makeTree(this.baseOffsetX + 4, this.baseOffsetY, this.baseOffsetZ + 4);
    }

    @Override
    public void add(int x, int y, int z) {
        if (((Tree)this.mainTree).add(x, y, z)) {
            return;
        }
        if (this.secondaryTree == null) {
            this.secondaryTree = this.makeSecondaryTree();
        }
        ((Tree)this.secondaryTree).add(x, y, z);
    }

    @Override
    public int getPresence(int x, int y, int z) {
        int result = ((Tree)this.mainTree).getPresence(x, y, z);
        if (result != -1) {
            return result;
        }
        if (this.secondaryTree != null) {
            return ((Tree)this.secondaryTree).getPresence(x, y, z);
        }
        return -1;
    }

    public static boolean checkApplicable(float buildDistance, class_1150 level) {
        if (buildDistance / 16.0f > 64.0f) {
            return false;
        }
        return level.method_3591() >> 4 <= 64;
    }
}

