/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadView;
import dev.vexor.radium.frapi.api.renderer.v1.model.ModelHelper;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.minecraft.class_1354;
import net.minecraft.class_837;

public abstract class EncodingFormat {
    static final int HEADER_BITS = 0;
    static final int HEADER_FACE_NORMAL = 1;
    static final int HEADER_TINT_INDEX = 2;
    static final int HEADER_TAG = 3;
    public static final int HEADER_STRIDE = 4;
    static final int VERTEX_X = 4;
    static final int VERTEX_Y = 5;
    static final int VERTEX_Z = 6;
    static final int VERTEX_COLOR = 7;
    static final int VERTEX_U = 8;
    static final int VERTEX_V = VERTEX_U + 1;
    static final int VERTEX_LIGHTMAP = 10;
    static final int VERTEX_NORMAL = 11;
    public static final int VERTEX_STRIDE = 7;
    public static final int QUAD_STRIDE = VERTEX_STRIDE * 4;
    public static final int QUAD_STRIDE_BYTES = QUAD_STRIDE * 4;
    public static final int TOTAL_STRIDE = 4 + QUAD_STRIDE;
    static final int[] EMPTY;
    private static final int DIRECTION_MASK;
    private static final int DIRECTION_BIT_COUNT;
    private static final int FACING_MASK;
    private static final int FACING_BIT_COUNT;
    private static final int MATERIAL_MASK;
    private static final int MATERIAL_BIT_COUNT;
    private static final int CULL_SHIFT = 0;
    private static final int CULL_INVERSE_MASK;
    private static final int LIGHT_SHIFT;
    private static final int LIGHT_INVERSE_MASK;
    private static final int NORMAL_FACE_SHIFT;
    private static final int NORMAL_FACE_INVERSE_MASK;
    private static final int NORMALS_SHIFT;
    private static final int NORMALS_COUNT = 4;
    private static final int NORMALS_MASK = 15;
    private static final int NORMALS_INVERSE_MASK;
    private static final int GEOMETRY_SHIFT;
    private static final int GEOMETRY_MASK = 7;
    private static final int GEOMETRY_INVERSE_MASK;
    private static final int MATERIAL_SHIFT;
    private static final int MATERIAL_INVERSE_MASK;

    private EncodingFormat() {
    }

    static class_1354 cullFace(int bits) {
        return ModelHelper.faceFromIndex(bits >>> 0 & DIRECTION_MASK);
    }

    static int cullFace(int bits, class_1354 face) {
        return bits & CULL_INVERSE_MASK | ModelHelper.toFaceIndex(face) << 0;
    }

    static class_1354 lightFace(int bits) {
        return ModelHelper.faceFromIndex(bits >>> LIGHT_SHIFT & DIRECTION_MASK);
    }

    static int lightFace(int bits, class_1354 face) {
        return bits & LIGHT_INVERSE_MASK | ModelHelper.toFaceIndex(face) << LIGHT_SHIFT;
    }

    static ModelQuadFacing normalFace(int bits) {
        return ModelQuadFacing.VALUES[bits >>> NORMAL_FACE_SHIFT & FACING_MASK];
    }

    static int normalFace(int bits, ModelQuadFacing face) {
        return bits & NORMAL_FACE_INVERSE_MASK | face.ordinal() << NORMAL_FACE_SHIFT;
    }

    static int normalFlags(int bits) {
        return bits >>> NORMALS_SHIFT & 0xF;
    }

    static int normalFlags(int bits, int normalFlags) {
        return bits & NORMALS_INVERSE_MASK | (normalFlags & 0xF) << NORMALS_SHIFT;
    }

    static int geometryFlags(int bits) {
        return bits >>> GEOMETRY_SHIFT & 7;
    }

    static int geometryFlags(int bits, int geometryFlags) {
        return bits & GEOMETRY_INVERSE_MASK | (geometryFlags & 7) << GEOMETRY_SHIFT;
    }

    static RenderMaterialImpl material(int bits) {
        return RenderMaterialImpl.byIndex(bits >>> MATERIAL_SHIFT & MATERIAL_MASK);
    }

    static int material(int bits, RenderMaterialImpl material) {
        return bits & MATERIAL_INVERSE_MASK | material.index() << MATERIAL_SHIFT;
    }

    static {
        if (VERTEX_STRIDE != QuadView.VANILLA_VERTEX_STRIDE) {
            throw new IllegalStateException(String.format("Sodium FRAPI vertex stride (%s) mismatched with rendering API (%s)", VERTEX_STRIDE, QuadView.VANILLA_VERTEX_STRIDE));
        }
        if (QUAD_STRIDE != QuadView.VANILLA_QUAD_STRIDE) {
            throw new IllegalStateException(String.format("Sodium FRAPI quad stride (%s) mismatched with rendering API (%s)", QUAD_STRIDE, QuadView.VANILLA_QUAD_STRIDE));
        }
        EMPTY = new int[TOTAL_STRIDE];
        DIRECTION_MASK = class_837.method_8342((int)7) - 1;
        DIRECTION_BIT_COUNT = Integer.bitCount(DIRECTION_MASK);
        FACING_MASK = class_837.method_8342((int)ModelQuadFacing.COUNT) - 1;
        FACING_BIT_COUNT = Integer.bitCount(FACING_MASK);
        MATERIAL_MASK = class_837.method_8342((int)RenderMaterialImpl.VALUE_COUNT) - 1;
        MATERIAL_BIT_COUNT = Integer.bitCount(MATERIAL_MASK);
        CULL_INVERSE_MASK = ~(DIRECTION_MASK << 0);
        LIGHT_SHIFT = 0 + DIRECTION_BIT_COUNT;
        LIGHT_INVERSE_MASK = ~(DIRECTION_MASK << LIGHT_SHIFT);
        NORMAL_FACE_SHIFT = LIGHT_SHIFT + DIRECTION_BIT_COUNT;
        NORMAL_FACE_INVERSE_MASK = ~(FACING_MASK << NORMAL_FACE_SHIFT);
        NORMALS_SHIFT = NORMAL_FACE_SHIFT + FACING_BIT_COUNT;
        NORMALS_INVERSE_MASK = ~(15 << NORMALS_SHIFT);
        GEOMETRY_SHIFT = NORMALS_SHIFT + 4;
        GEOMETRY_INVERSE_MASK = ~(7 << GEOMETRY_SHIFT);
        MATERIAL_SHIFT = GEOMETRY_SHIFT + 3;
        MATERIAL_INVERSE_MASK = ~(MATERIAL_MASK << MATERIAL_SHIFT);
        if (MATERIAL_SHIFT + MATERIAL_BIT_COUNT > 32) {
            throw new IllegalArgumentException(String.format("Sodium FRAPI header encoding bit count (%s) exceeds integer bit length", TOTAL_STRIDE));
        }
    }
}

