/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import dev.vexor.radium.frapi.api.renderer.v1.material.RenderMaterial;
import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadEmitter;
import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadView;
import dev.vexor.radium.frapi.api.renderer.v1.model.SpriteFinder;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.frapi.SodiumRenderer;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.TextureHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.QuadViewImpl;
import net.legacyfabric.fabric.api.util.TriState;
import net.minecraft.class_1354;
import net.minecraft.class_1639;
import net.minecraft.class_2437;
import org.jetbrains.annotations.Nullable;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter {
    @Nullable
    private class_1639 cachedSprite;
    static final int[] DEFAULT = (int[])EncodingFormat.EMPTY.clone();

    public void cachedSprite(@Nullable class_1639 sprite) {
        this.cachedSprite = sprite;
    }

    public class_1639 sprite(SpriteFinder finder) {
        class_1639 sprite = this.cachedSprite;
        if (sprite == null) {
            this.cachedSprite = sprite = finder.find(this);
        }
        return sprite;
    }

    public void clear() {
        System.arraycopy(DEFAULT, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
        this.cachedSprite(null);
    }

    @Override
    public void load() {
        super.load();
        this.cachedSprite(null);
    }

    @Override
    public MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    @Override
    public MutableQuadViewImpl color(int vertexIndex, int color) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    @Override
    public MutableQuadViewImpl uv(int vertexIndex, float u, float v) {
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        this.cachedSprite(null);
        return this;
    }

    @Override
    public MutableQuadViewImpl spriteBake(class_1639 sprite, int bakeFlags) {
        TextureHelper.bakeSprite(this, sprite, bakeFlags);
        this.cachedSprite(sprite);
        return this;
    }

    @Override
    public MutableQuadViewImpl lightmap(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP] = lightmap;
        return this;
    }

    protected void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    @Override
    public MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormI8.pack(x, y, z);
        return this;
    }

    @Override
    public final MutableQuadViewImpl cullFace(@Nullable class_1354 face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.nominalFace(face);
        return this;
    }

    @Override
    public final MutableQuadViewImpl nominalFace(@Nullable class_1354 face) {
        this.nominalFace = face;
        return this;
    }

    @Override
    public final MutableQuadViewImpl material(RenderMaterial material) {
        this.data[this.baseIndex + 0] = EncodingFormat.material(this.data[this.baseIndex + 0], (RenderMaterialImpl)material);
        return this;
    }

    @Override
    public final MutableQuadViewImpl tintIndex(int tintIndex) {
        this.data[this.baseIndex + 2] = tintIndex;
        return this;
    }

    @Override
    public final MutableQuadViewImpl tag(int tag) {
        this.data[this.baseIndex + 3] = tag;
        return this;
    }

    private void fromVanillaInternal(int[] quadData, int startIndex) {
        System.arraycopy(quadData, startIndex, this.data, this.baseIndex + 4, QuadView.VANILLA_QUAD_STRIDE);
        int colorIndex = this.baseIndex + EncodingFormat.VERTEX_COLOR;
        for (int i = 0; i < 4; ++i) {
            this.data[colorIndex] = ColorHelper.fromVanillaColor(this.data[colorIndex]);
            colorIndex += EncodingFormat.VERTEX_STRIDE;
        }
    }

    @Override
    public final MutableQuadViewImpl fromVanilla(int[] quadData, int startIndex) {
        this.fromVanillaInternal(quadData, startIndex);
        this.isGeometryInvalid = true;
        this.cachedSprite(null);
        return this;
    }

    @Override
    public final MutableQuadViewImpl fromVanilla(class_2437 quad, RenderMaterial material, @Nullable class_1354 cullFace) {
        this.fromVanillaInternal(quad.method_9979(), 0);
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(0, cullFace);
        this.nominalFace(quad.method_9982());
        this.tintIndex(quad.method_9981());
        if (!((BakedQuadView)quad).hasShade()) {
            material = RenderMaterialImpl.setDisableDiffuse((RenderMaterialImpl)material, true);
        }
        if (material.ambientOcclusion().orElse(true) && !((BakedQuadView)quad).hasAO()) {
            material = RenderMaterialImpl.setAmbientOcclusion((RenderMaterialImpl)material, TriState.FALSE);
        }
        this.material(material);
        this.tag(0);
        BakedQuadView bakedView = (BakedQuadView)quad;
        NormI8.unpack(bakedView.getFaceNormal(), this.faceNormal);
        this.data[this.baseIndex + 1] = bakedView.getFaceNormal();
        int headerBits = EncodingFormat.lightFace(this.data[this.baseIndex + 0], bakedView.getLightFace());
        headerBits = EncodingFormat.normalFace(headerBits, bakedView.getNormalFace());
        this.data[this.baseIndex + 0] = EncodingFormat.geometryFlags(headerBits, bakedView.getFlags());
        this.isGeometryInvalid = false;
        return this;
    }

    protected abstract void emitDirectly();

    public final void transformAndEmit() {
        this.emitDirectly();
    }

    @Override
    public final MutableQuadViewImpl emit() {
        this.transformAndEmit();
        this.clear();
        return this;
    }

    static {
        MutableQuadViewImpl quad = new MutableQuadViewImpl(){

            @Override
            protected void emitDirectly() {
            }
        };
        quad.data = DEFAULT;
        quad.color(-1, -1, -1, -1);
        quad.cullFace(null);
        quad.material(SodiumRenderer.STANDARD_MATERIAL);
        quad.tintIndex(-1);
    }
}

