/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.cloned;

import dev.vexor.radium.compat.mojang.minecraft.ChunkNibbleArrayExt;
import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.class_1150;
import net.minecraft.class_1161;
import net.minecraft.class_1170;
import net.minecraft.class_1194;
import net.minecraft.class_1196;
import net.minecraft.class_1197;
import net.minecraft.class_1752;
import net.minecraft.class_197;
import net.minecraft.class_2232;
import net.minecraft.class_226;
import net.minecraft.class_2552;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClonedChunkSection {
    private static final class_1194 DEFAULT_SKY_LIGHT_ARRAY = new ChunkNibbleArrayExt(15);
    private static final class_1194 DEFAULT_BLOCK_LIGHT_ARRAY = new class_1194();
    private static final class_2232 EMPTY_BLOCK_STATE = class_1752.field_7312.method_8633();
    private final SectionPos pos;
    @Nullable
    private final Int2ReferenceMap<class_226> blockEntityMap;
    @Nullable
    private class_1194[] lightDataArrays;
    @Nullable
    private final char[] blockData;
    @Nullable
    private final class_1170[] biomeData;
    private long lastUsedTimestamp = Long.MAX_VALUE;
    private final class_1197 section;
    private final class_1150 level;
    private final class_1196 chunk;

    public ClonedChunkSection(class_1150 level, class_1196 chunk, @Nullable class_1197 section, SectionPos pos) {
        this.pos = pos;
        this.chunk = chunk;
        char[] blockData = null;
        class_1170[] biomeData = null;
        Int2ReferenceMap<class_226> blockEntityMap = null;
        if (section != null) {
            if (!section.method_3925()) {
                blockData = section.method_3942();
                blockEntityMap = ClonedChunkSection.copyBlockEntities(chunk, pos);
            }
            biomeData = ClonedChunkSection.convertBiomeArray(chunk.method_3921());
        }
        this.blockData = blockData;
        this.biomeData = biomeData;
        this.blockEntityMap = blockEntityMap;
        this.lightDataArrays = ClonedChunkSection.copyLightData(level, section);
        this.section = section;
        this.level = level;
    }

    private static class_1170[] convertBiomeArray(byte[] biomeIds) {
        class_1170[] biomes = new class_1170[biomeIds.length];
        for (int i = 0; i < biomeIds.length; ++i) {
            biomes[i] = class_1170.method_6428((int)(biomeIds[i] & 0xFF));
            if (biomes[i] != null) continue;
            biomes[i] = class_1170.field_4638;
        }
        return biomes;
    }

    @NotNull
    private static class_1194[] copyLightData(class_1150 level, class_1197 section) {
        class_1194[] arrays = new class_1194[2];
        arrays[class_1161.field_9220.ordinal()] = ClonedChunkSection.copyLightArray(section, class_1161.field_9220);
        if (!level.field_4558.method_9177()) {
            arrays[class_1161.field_9219.ordinal()] = ClonedChunkSection.copyLightArray(section, class_1161.field_9219);
        }
        return arrays;
    }

    @NotNull
    private static class_1194 copyLightArray(class_1197 section, class_1161 type) {
        class_1194 array;
        if (section != null) {
            array = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case class_1161.field_9219 -> section.method_3947();
                case class_1161.field_9220 -> section.method_3946();
            };
        } else {
            array = null;
        }
        if (array == null) {
            array = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case class_1161.field_9219 -> DEFAULT_SKY_LIGHT_ARRAY;
                case class_1161.field_9220 -> DEFAULT_BLOCK_LIGHT_ARRAY;
            };
        }
        return array;
    }

    @Nullable
    private static Int2ReferenceMap<class_226> copyBlockEntities(class_1196 chunk, SectionPos pos) {
        Int2ReferenceOpenHashMap<class_226> blockEntities = new Int2ReferenceOpenHashMap<class_226>();
        for (int y = pos.minBlockY(); y <= pos.maxBlockY(); ++y) {
            for (int z = pos.minBlockZ(); z <= pos.maxBlockZ(); ++z) {
                for (int x = pos.minBlockX(); x <= pos.maxBlockX(); ++x) {
                    class_226 blockEntity;
                    class_2552 blockPos = new class_2552(x, y, z);
                    class_197 block = chunk.method_9133(blockPos);
                    if (!block.method_478() || (blockEntity = chunk.method_9138(blockPos, class_1196.class_2251.field_9951)) == null) continue;
                    blockEntities.put(LevelSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF), blockEntity);
                }
            }
        }
        return blockEntities;
    }

    public SectionPos getPosition() {
        return this.pos;
    }

    @Nullable
    public class_2232[] getBlockData() {
        if (this.section == null) {
            return null;
        }
        if (this.blockData == null) {
            return null;
        }
        class_2232[] blockData = new class_2232[4096];
        for (int i = 0; i < this.blockData.length; ++i) {
            class_2232 state = (class_2232)class_197.field_9284.method_7322((int)this.blockData[i]);
            blockData[i] = state == null ? EMPTY_BLOCK_STATE : state;
        }
        return blockData;
    }

    @Nullable
    public class_1170[] getBiomeData() {
        return this.biomeData;
    }

    @Nullable
    public Int2ReferenceMap<class_226> getBlockEntityMap() {
        return this.blockEntityMap;
    }

    @Nullable
    public class_1194 getLightArray(class_1161 type) {
        return this.lightDataArrays[type.ordinal()];
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    public class_1197 getSection() {
        return this.section;
    }

    public class_1196 getChunk() {
        return this.chunk;
    }
}

