/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.IdentifierWithSource;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1644;
import net.minecraft.class_1645;
import net.minecraft.class_1647;
import net.minecraft.class_1653;
import net.minecraft.class_1655;

public class ResourceList {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.TEXTURE_PACK);
    private static ResourceList instance;
    private static final Map<class_1655, Integer> resourcePackOrder;
    private final class_1655 resourcePack;
    private final Set<IdentifierWithSource> allResources = new TreeSet<IdentifierWithSource>(new IdentifierWithSource.Comparator1());

    public static ResourceList getInstance() {
        if (instance == null) {
            List<class_1655> resourcePacks = TexturePackAPI.getResourcePacks(null);
            int order = resourcePacks.size();
            resourcePackOrder.clear();
            for (class_1655 resourcePack : resourcePacks) {
                resourcePackOrder.put(resourcePack, order);
                --order;
            }
            instance = new ResourceList();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static int getResourcePackOrder(class_1655 resourcePack) {
        Integer i = resourcePackOrder.get(resourcePack);
        return i == null ? Integer.MAX_VALUE : i;
    }

    private ResourceList() {
        this.resourcePack = null;
        for (class_1655 resourcePack : TexturePackAPI.getResourcePacks(null)) {
            ResourceList sublist;
            if (resourcePack instanceof class_1647) {
                sublist = new ResourceList((class_1647)resourcePack);
            } else if (resourcePack instanceof class_1645) {
                sublist = new ResourceList((class_1645)resourcePack);
            } else {
                if (!(resourcePack instanceof class_1644)) continue;
                sublist = new ResourceList((class_1644)resourcePack);
            }
            this.allResources.removeAll(sublist.allResources);
            this.allResources.addAll(sublist.allResources);
        }
        logger.fine("new %s", this);
        if (logger.isLoggable(Level.FINEST)) {
            for (IdentifierWithSource resource : this.allResources) {
                logger.finest("%s -> %s", new Object[]{resource, resource.getSource().method_5899()});
            }
        }
    }

    private ResourceList(class_1647 resourcePack) {
        this.resourcePack = resourcePack;
        this.scanZipFile(resourcePack.field_6612);
        logger.fine("new %s", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceList(class_1645 resourcePack) {
        Map map;
        this.resourcePack = resourcePack;
        String version = "1.7.10";
        File jar = MCPatcherUtils.getMinecraftPath("versions", version, version + ".jar");
        if (jar.isFile()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jar);
                this.scanZipFile(zipFile);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(zipFile);
                    throw throwable;
                }
                MCPatcherUtils.close(zipFile);
            }
            MCPatcherUtils.close(zipFile);
        }
        if ((map = resourcePack.field_8108) != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                File file = (File)entry.getValue();
                class_1653 resource = new class_1653(key);
                this.addResource(resource, file.isFile(), file.isDirectory());
            }
        }
        if (!this.allResources.isEmpty()) {
            logger.fine("new %s", this);
        }
    }

    private ResourceList(class_1644 resourcePack) {
        this.resourcePack = resourcePack;
        File directory = resourcePack.field_6605;
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        HashSet<String> allFiles = new HashSet<String>();
        ResourceList.listAllFiles(directory, "", allFiles);
        for (String path : allFiles) {
            class_1653 resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            File file = new File(directory, path);
            this.addResource(resource, file.isFile(), file.isDirectory());
        }
        logger.fine("new %s", this);
    }

    private void scanZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String path = zipEntry.getName();
            class_1653 resource = TexturePackAPI.parsePath(path);
            if (resource == null) continue;
            this.addResource(resource, !zipEntry.isDirectory(), zipEntry.isDirectory());
        }
    }

    private static void listAllFiles(File base, String subdir, Set<String> files) {
        File[] entries = new File(base, subdir).listFiles();
        if (entries == null) {
            return;
        }
        for (File file : entries) {
            String newPath = subdir + file.getName();
            if (!files.add(newPath) || !file.isDirectory()) continue;
            ResourceList.listAllFiles(base, subdir + file.getName() + "/", files);
        }
    }

    private void addResource(class_1653 resource, boolean isFile, boolean isDirectory) {
        if (isFile) {
            this.allResources.add(new IdentifierWithSource(this.resourcePack, resource));
        } else if (isDirectory) {
            if (!resource.method_5890().endsWith("/")) {
                resource = new class_1653(resource.method_5891(), resource.method_5890() + "/");
            }
            this.allResources.add(new IdentifierWithSource(this.resourcePack, resource));
        }
    }

    public List<class_1653> listResources(String directory, String suffix, boolean sortByFilename) {
        return this.listResources(directory, suffix, true, false, sortByFilename);
    }

    public List<class_1653> listResources(String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        return this.listResources(null, directory, suffix, recursive, directories, sortByFilename);
    }

    public List<class_1653> listResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (suffix == null) {
            suffix = "";
        }
        if (MCPatcherUtils.isNullOrEmpty((String)directory)) {
            directory = "";
        } else if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        TreeSet<IdentifierWithSource> tmpList = new TreeSet<IdentifierWithSource>(new IdentifierWithSource.Comparator1(true, sortByFilename ? suffix : null));
        boolean allNamespaces = MCPatcherUtils.isNullOrEmpty(namespace);
        for (IdentifierWithSource resource : this.allResources) {
            String subpath;
            String path;
            if (directories != resource.isDirectory() || !allNamespaces && !namespace.equals(resource.method_5891()) || !(path = resource.method_5890()).endsWith(suffix) || !path.startsWith((String)directory) || !recursive && (subpath = path.substring(((String)directory).length())).contains("/")) continue;
            tmpList.add(resource);
        }
        return new ArrayList<class_1653>(tmpList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceList: ");
        if (this.resourcePack == null) {
            sb.append("(combined) ");
        } else {
            sb.append(this.resourcePack.method_5899()).append(' ');
        }
        int fileCount = 0;
        int directoryCount = 0;
        HashSet<String> namespaces = new HashSet<String>();
        for (IdentifierWithSource resource : this.allResources) {
            if (resource.isDirectory()) {
                ++directoryCount;
            } else {
                ++fileCount;
            }
            namespaces.add(resource.method_5891());
        }
        sb.append(fileCount).append(" files, ");
        sb.append(directoryCount).append(" directories in ");
        sb.append(namespaces.size()).append(" namespaces");
        return sb.toString();
    }

    static {
        resourcePackOrder = new WeakHashMap<class_1655, Integer>();
    }
}

