/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.sky;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.minecraft.class_1653;
import net.minecraft.class_2359;
import net.minecraft.class_502;

public class FireworksHelper {
    private static final int LIT_LAYER = 3;
    private static final int EXTRA_LAYER = 4;
    private static final class_1653 PARTICLE_PROPERTIES = TexturePackAPI.newMCPatcherResourceLocation("particle.properties");
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.BETTER_SKIES);
    private static final boolean enable = SodiumClientMod.options().quality.brightenFireworks;
    private static BlendMethod blendMethod;

    public static int getFXLayer(class_502 entity) {
        if (enable && (entity instanceof class_2359.class_1339 || entity instanceof class_2359.class_1340)) {
            return 4;
        }
        return entity.method_1284();
    }

    public static boolean skipThisLayer(boolean skip, int layer) {
        return skip || layer == 3 || !enable && layer > 3;
    }

    public static void setParticleBlendMethod(int layer, int pass, boolean setDefault) {
        if (enable && layer == 4 && blendMethod != null) {
            blendMethod.applyBlending();
        } else if (setDefault) {
            GLAPI.glBlendFuncSeparate(770, 771, 1, 0);
        }
    }

    static void reload() {
        PropertiesFile properties = PropertiesFile.getNonNull(logger, PARTICLE_PROPERTIES);
        String blend = properties.getString("blend.4", "add");
        blendMethod = BlendMethod.parse(blend);
        if (blendMethod == null) {
            properties.error("%s: unknown blend method %s", PARTICLE_PROPERTIES, blend);
        } else if (enable) {
            properties.config("using %s blending for fireworks particles", blendMethod);
        } else {
            properties.config("using default blending for fireworks particles", new Object[0]);
        }
    }
}

