/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.compat.mojang.minecraft.gui.event;

import dev.vexor.radium.compat.mojang.minecraft.gui.event.GuiEventListener;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface GuiParentEventListener
extends GuiEventListener {
    public List<? extends GuiEventListener> children();

    default public Optional<GuiEventListener> hoveredElement(double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    @Override
    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.mouseReleased(mouseX, mouseY, button)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double mouseX, double mouseY, int button) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button);
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double verticalAmount, double amount) {
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.mouseScrolled(mouseX, mouseY, verticalAmount, amount)).isPresent();
    }

    @Override
    default public boolean keyPressed(int keyCode, char typedChar) {
        return this.getFocused() != null && this.getFocused().keyPressed(keyCode, typedChar);
    }

    @Nullable
    public GuiEventListener getFocused();

    public void setFocused(@Nullable GuiEventListener var1);

    @Override
    default public boolean changeFocus(boolean lookForwards) {
        GuiEventListener element = this.getFocused();
        if (element == null || !element.changeFocus(lookForwards)) {
            GuiEventListener element2;
            Supplier<GuiEventListener> supplier;
            BooleanSupplier booleanSupplier;
            List<? extends GuiEventListener> list = this.children();
            int i = list.indexOf(element);
            int j = element != null && i >= 0 ? i + (lookForwards ? 1 : 0) : (lookForwards ? 0 : list.size());
            ListIterator<? extends GuiEventListener> listIterator = list.listIterator(j);
            BooleanSupplier booleanSupplier2 = lookForwards ? listIterator::hasNext : (booleanSupplier = listIterator::hasPrevious);
            Supplier<GuiEventListener> supplier2 = lookForwards ? listIterator::next : (supplier = listIterator::previous);
            do {
                if (booleanSupplier.getAsBoolean()) continue;
                this.setFocused(null);
                return false;
            } while (!(element2 = supplier.get()).changeFocus(lookForwards));
            this.setFocused(element2);
        }
        return true;
    }
}

