/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.frapi.impl.renderer;

import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadView;
import dev.vexor.radium.frapi.api.renderer.v1.model.SpriteFinder;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1533;
import net.minecraft.class_1639;
import net.minecraft.class_1653;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpriteFinderImpl
implements SpriteFinder {
    private static final Logger LOGGER = LogManager.getLogger(SpriteFinderImpl.class);
    private final Node root = new Node(0.5f, 0.5f, 0.25f);
    private final class_1533 spriteAtlasTexture;
    private int badSpriteCount = 0;

    public SpriteFinderImpl(Map<class_1653, class_1639> sprites, class_1533 spriteAtlasTexture) {
        this.spriteAtlasTexture = spriteAtlasTexture;
        sprites.values().forEach(this.root::add);
    }

    @Override
    public class_1639 find(QuadView quad) {
        float u = 0.0f;
        float v = 0.0f;
        for (int i = 0; i < 4; ++i) {
            u += quad.u(i);
            v += quad.v(i);
        }
        return this.find(u * 0.25f, v * 0.25f);
    }

    @Override
    public class_1639 find(float u, float v) {
        return this.root.find(u, v);
    }

    public static SpriteFinderImpl get(class_1533 atlas) {
        return ((SpriteFinderAccess)atlas).fabric$spriteFinder();
    }

    private class Node {
        final float midU;
        final float midV;
        final float cellRadius;
        Object lowLow = null;
        Object lowHigh = null;
        Object highLow = null;
        Object highHigh = null;
        static final float EPS = 1.0E-5f;

        Node(float midU, float midV, float radius) {
            this.midU = midU;
            this.midV = midV;
            this.cellRadius = radius;
        }

        void add(class_1639 sprite) {
            boolean highV;
            if (sprite.method_5344() < -1.0E-5f || sprite.method_5345() > 1.00001f || sprite.method_5346() < -1.0E-5f || sprite.method_5347() > 1.00001f) {
                if (SpriteFinderImpl.this.badSpriteCount++ < 5) {
                    String errorMessage = "SpriteFinderImpl: Skipping sprite {} with broken bounds [{}, {}]x[{}, {}]. Sprite bounds should be between 0 and 1.";
                    LOGGER.error(errorMessage, new Object[]{sprite.method_5348(), Float.valueOf(sprite.method_5344()), Float.valueOf(sprite.method_5345()), Float.valueOf(sprite.method_5346()), Float.valueOf(sprite.method_5347())});
                }
                return;
            }
            boolean lowU = sprite.method_5344() < this.midU - 1.0E-5f;
            boolean highU = sprite.method_5345() > this.midU + 1.0E-5f;
            boolean lowV = sprite.method_5346() < this.midV - 1.0E-5f;
            boolean bl = highV = sprite.method_5347() > this.midV + 1.0E-5f;
            if (lowU && lowV) {
                this.addInner(sprite, this.lowLow, -1, -1, q -> {
                    this.lowLow = q;
                });
            }
            if (lowU && highV) {
                this.addInner(sprite, this.lowHigh, -1, 1, q -> {
                    this.lowHigh = q;
                });
            }
            if (highU && lowV) {
                this.addInner(sprite, this.highLow, 1, -1, q -> {
                    this.highLow = q;
                });
            }
            if (highU && highV) {
                this.addInner(sprite, this.highHigh, 1, 1, q -> {
                    this.highHigh = q;
                });
            }
        }

        private void addInner(class_1639 sprite, Object quadrant, int uStep, int vStep, Consumer<Object> setter) {
            if (quadrant == null) {
                setter.accept(sprite);
            } else if (quadrant instanceof Node) {
                ((Node)quadrant).add(sprite);
            } else {
                Node n = new Node(this.midU + this.cellRadius * (float)uStep, this.midV + this.cellRadius * (float)vStep, this.cellRadius * 0.5f);
                if (quadrant instanceof class_1639) {
                    n.add((class_1639)quadrant);
                }
                n.add(sprite);
                setter.accept(n);
            }
        }

        private class_1639 find(float u, float v) {
            if (u < this.midU) {
                return v < this.midV ? this.findInner(this.lowLow, u, v) : this.findInner(this.lowHigh, u, v);
            }
            return v < this.midV ? this.findInner(this.highLow, u, v) : this.findInner(this.highHigh, u, v);
        }

        private class_1639 findInner(Object quadrant, float u, float v) {
            if (quadrant instanceof class_1639) {
                return (class_1639)quadrant;
            }
            if (quadrant instanceof Node) {
                return ((Node)quadrant).find(u, v);
            }
            return SpriteFinderImpl.this.spriteAtlasTexture.method_10316(class_1533.field_11196);
        }
    }

    public static interface SpriteFinderAccess {
        public SpriteFinderImpl fabric$spriteFinder();
    }
}

