/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.mixin.config;

import dev.vexor.radium.mixin.MixinOption;
import dev.vexor.radium.mixin.config.CaffeineConfig;
import dev.vexor.radium.mixin.config.Option;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.caffeinemc.mods.sodium.client.data.config.MixinConfig;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public abstract class AbstractCaffeineConfigMixinPlugin
implements IMixinConfigPlugin {
    private CaffeineConfig config;
    private MixinConfig sodiumConfig;

    public void onLoad(String mixinPackage) {
        this.config = this.createConfig();
        this.logger().info("Loaded configuration file for {}: {} options available, {} override(s) found", new Object[]{this.config.getModName(), this.config.getOptionCount(), this.config.getOptionOverrideCount()});
        try {
            this.sodiumConfig = MixinConfig.load(new File("./config/radium-mixins.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Radium", e);
        }
    }

    public static Optional<Path> getPaulscodePath() {
        for (Path path : FabricLauncherBase.getLauncher().getClassPath()) {
            if (!path.toString().contains("librarylwjglopenal")) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    protected abstract CaffeineConfig createConfig();

    protected abstract String mixinPackageRoot();

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith("dev.vexor.radium.mixin.sodium")) {
            String mixin = mixinClassName.substring("dev.vexor.radium.mixin.sodium.".length());
            MixinOption option = this.sodiumConfig.getEffectiveOptionForMixin(mixin);
            if (option == null) {
                this.logger().error("No rules matched mixin '{}', treating as foreign and disabling!", new Object[]{mixin});
                return false;
            }
            if (option.isOverridden()) {
                Object source = "[unknown]";
                if (option.isUserDefined()) {
                    source = "user configuration";
                } else if (option.isModDefined()) {
                    source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
                }
                if (option.isEnabled()) {
                    this.logger().warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", new Object[]{mixin, option.getName(), source});
                } else {
                    this.logger().warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", new Object[]{mixin, option.getName(), source});
                }
            }
            return option.isEnabled();
        }
        if (mixinClassName.startsWith("dev.vexor.radium.mixin.extra")) {
            String mixin = mixinClassName.substring(this.mixinPackageRoot().length());
            Option option = this.config.getEffectiveOptionForMixin(mixin);
            if (option == null) {
                throw new IllegalStateException(String.format("No options matched mixin '%s'! Mixins in this config must be under a registered option name", mixin));
            }
            if (option.isOverridden()) {
                Object source = "[unknown]";
                if (option.isUserDefined()) {
                    source = "user configuration";
                } else if (option.isModDefined()) {
                    source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
                }
                if (option.isEnabled()) {
                    this.logger().warn("Force-enabling mixin '{}' as option '{}' (added by {}) enables it", new Object[]{mixin, option.getName(), source});
                } else {
                    this.logger().warn("Force-disabling mixin '{}' as option '{}' (added by {}) disables it and children", new Object[]{mixin, option.getName(), source});
                }
            }
            return option.isEnabled();
        }
        return true;
    }

    private Logger logger() {
        return this.config.getLogger();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

