/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.options.client.gui.frame;

import dev.vexor.radium.compat.mojang.minecraft.gui.Renderable;
import dev.vexor.radium.compat.mojang.minecraft.gui.event.GuiEventListener;
import dev.vexor.radium.compat.mojang.minecraft.gui.event.GuiParentEventListener;
import java.util.ArrayList;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1600;
import net.minecraft.class_389;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class AbstractFrame
extends AbstractWidget
implements GuiParentEventListener {
    protected final Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<Renderable> drawable = new ArrayList<Renderable>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    protected boolean renderOutline;
    private GuiEventListener focused;
    private boolean dragging;

    public AbstractFrame(Dim2i dim, boolean renderOutline) {
        this.dim = dim;
        this.renderOutline = renderOutline;
    }

    public void buildFrame() {
        for (GuiEventListener guiEventListener : this.children) {
            if (guiEventListener instanceof AbstractFrame) {
                AbstractFrame abstractFrame = (AbstractFrame)guiEventListener;
                this.controlElements.addAll(abstractFrame.controlElements);
            }
            if (guiEventListener instanceof ControlElement) {
                ControlElement controlElement = (ControlElement)guiEventListener;
                this.controlElements.add(controlElement);
            }
            if (!(guiEventListener instanceof Renderable)) continue;
            Renderable drawable = (Renderable)((Object)guiEventListener);
            this.drawable.add(drawable);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (this.renderOutline) {
            this.drawRectOutline(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        }
        for (Renderable drawable : this.drawable) {
            drawable.render(mouseX, mouseY, delta);
        }
    }

    public void applyScissor(int x, int y, int width, int height, Runnable action) {
        double scale = new class_389(class_1600.method_2965()).method_1049();
        GL11.glEnable(3089);
        GL11.glScissor((int)((double)x * scale), (int)((double)class_1600.method_2965().method_6633().field_7984 - (double)(y + height) * scale), (int)((double)width * scale), (int)((double)height * scale));
        action.run();
        GL11.glDisable(3089);
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            AbstractFrame.addQuad(vertices, x, y, w, y + 1.0, a, r, g, b);
            AbstractFrame.addQuad(vertices, x, h - 1.0, w, h, a, r, g, b);
            AbstractFrame.addQuad(vertices, x, y, x + 1.0, h, a, r, g, b);
            AbstractFrame.addQuad(vertices, w - 1.0, y, w, h, a, r, g, b);
        });
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }

    @Override
    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

