/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.options.client.gui.frame;

import dev.vexor.radium.options.client.gui.OptionExtended;
import dev.vexor.radium.options.client.gui.frame.AbstractFrame;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_1664;
import net.minecraft.class_370;
import org.apache.commons.lang3.Validate;

public class OptionPageFrame
extends AbstractFrame {
    protected final Dim2i originalDim;
    protected final OptionPage page;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page) {
        super(dim, renderOutline);
        this.originalDim = new Dim2i(dim.getOriginX(), dim.getOriginY(), dim.getWidth(), dim.getHeight());
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group2 : this.page.getGroups()) {
                y += group2.getOptions().size() * 18;
                if (group2 == lastGroup) continue;
                y += 4;
            }
        }
        this.dim.setHeight(y);
        this.page.getGroups().forEach(group -> group.getOptions().forEach(option -> {
            if (option instanceof OptionExtended) {
                OptionExtended optionExtended = (OptionExtended)option;
                optionExtended.setParentDimension(this.dim);
            }
        }));
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.getOriginX(), this.dim.getOriginY() + y, this.dim.getWidth(), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(controlElement -> controlElement.getDimensions().overlapWith(this.originalDim)).filter(AbstractWidget::isHovered).findFirst().orElse(null);
        super.render(mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && this.originalDim.containsCursor(mouseX, mouseY) && hoveredElement.isHovered()) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        class_370 fontRenderer = class_1600.method_2965().field_3814;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.getWidth();
        int boxY = dim.getLimitY();
        int boxX = dim.getOriginX();
        Option<?> option = element.getOption();
        ArrayList<CallSite> tooltip = new ArrayList<CallSite>(fontRenderer.method_971(option.getTooltip().method_7472(), boxWidth - 6));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add((CallSite)((Object)(String.valueOf(class_1442.field_5490) + class_1664.method_5934((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName().method_7472()}))));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + 3)) > (boxYCutoff = this.originalDim.getLimitY())) {
            boxY -= boxHeight + dim.getHeight();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        this.drawRect(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawRectOutline(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -7019309);
        for (int i = 0; i < tooltip.size(); ++i) {
            fontRenderer.method_4247((String)tooltip.get(i), boxX + 3, boxY + 3 + i * 12, -1);
        }
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page);
        }
    }
}

