/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.shader;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.minecraft.class_1653;

public class ShaderParser {
    private final Object2IntMap<String> includeIds = new Object2IntArrayMap<String>();
    private final List<String> lines = new LinkedList<String>();
    private static final Pattern IMPORT_PATTERN = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");

    public static ParsedShader parseShader(String src, ShaderConstants constants) {
        ShaderParser parser = new ShaderParser();
        parser.parseShader("_root", src);
        parser.prependDefineStrings(constants);
        return parser.finish();
    }

    private ShaderParser() {
    }

    public void parseShader(String name, String src) {
        int lineNumber = 0;
        try (BufferedReader reader = new BufferedReader(new StringReader(src));){
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("#version")) {
                    this.lines.add(line);
                    this.lines.add(this.lineDirectiveFor(name, lineNumber));
                    continue;
                }
                if (line.startsWith("#import")) {
                    this.lines.add("// START " + line);
                    this.processImport(line);
                    this.lines.add("// END " + line);
                    this.lines.add(this.lineDirectiveFor(name, lineNumber));
                    continue;
                }
                this.lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read shader sources", e);
        }
    }

    private String lineDirectiveFor(String name, int line) {
        int idNumber;
        if (!this.includeIds.containsKey(name)) {
            idNumber = this.includeIds.size();
            this.includeIds.put(name, idNumber);
        } else {
            idNumber = this.includeIds.getInt(name);
        }
        return "#line " + (line + 1) + " " + idNumber;
    }

    private void processImport(String line) {
        class_1653 name = this.parseImport(line);
        String nameString = name.toString();
        this.lines.add(this.lineDirectiveFor(nameString, 0));
        this.parseShader(nameString, ShaderLoader.getShaderSource(name));
    }

    private class_1653 parseImport(String line) {
        Matcher matcher = IMPORT_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + String.valueOf(IMPORT_PATTERN) + ")");
        }
        String namespace = matcher.group("namespace");
        String path = matcher.group("path");
        return new class_1653(namespace, path);
    }

    private void prependDefineStrings(ShaderConstants constants) {
        this.lines.addAll(1, constants.getDefineStrings());
    }

    private ParsedShader finish() {
        String[] includeIds = new String[this.includeIds.size()];
        this.includeIds.forEach((name, id) -> {
            includeIds[id.intValue()] = name;
        });
        return new ParsedShader(String.join((CharSequence)"\n", this.lines), includeIds);
    }

    public record ParsedShader(String src, String[] includeIds) {
    }
}

