/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import dev.vexor.radium.compat.mojang.minecraft.gui.input.CommonInputs;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.TextProvider;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_388;
import org.apache.commons.lang3.Validate;

public class CyclingControl<T extends Enum<T>>
implements Control<T> {
    private final Option<T> option;
    private final T[] allowedValues;
    private final class_1982[] names;

    public CyclingControl(Option<T> option, Class<T> enumType) {
        this(option, enumType, (Enum[])enumType.getEnumConstants());
    }

    public CyclingControl(Option<T> option, Class<T> enumType, class_1982[] names) {
        Object[] universe = (Enum[])enumType.getEnumConstants();
        Validate.isTrue((universe.length == names.length ? 1 : 0) != 0, (String)"Mismatch between universe length and names array length", (Object[])new Object[0]);
        Validate.notEmpty((Object[])universe, (String)"The enum universe must contain at least one item", (Object[])new Object[0]);
        this.option = option;
        this.allowedValues = universe;
        this.names = names;
    }

    public CyclingControl(Option<T> option, Class<T> enumType, T[] allowedValues) {
        Enum[] universe = (Enum[])enumType.getEnumConstants();
        this.option = option;
        this.allowedValues = allowedValues;
        this.names = new class_1982[universe.length];
        for (int i = 0; i < this.names.length; ++i) {
            Enum value = universe[i];
            Object name = value instanceof TextProvider ? ((TextProvider)((Object)value)).getLocalizedName() : new class_1989(value.name());
            this.names[i] = name;
        }
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    @Override
    public ControlElement<T> createElement(Dim2i dim) {
        return new CyclingControlElement(this.option, dim, this.allowedValues, this.names);
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    private static class CyclingControlElement<T extends Enum<T>>
    extends ControlElement<T> {
        private final T[] allowedValues;
        private final class_1982[] names;
        private int currentIndex;

        public CyclingControlElement(Option<T> option, Dim2i dim, T[] allowedValues, class_1982[] names) {
            super(option, dim);
            this.allowedValues = allowedValues;
            this.names = names;
            this.currentIndex = 0;
            for (int i = 0; i < allowedValues.length; ++i) {
                if (allowedValues[i] != option.getValue()) continue;
                this.currentIndex = i;
                break;
            }
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            Enum value = (Enum)this.option.getValue();
            class_1982 name = this.names[value.ordinal()];
            int strWidth = this.getStringWidth(name);
            this.drawString(name, this.dim.getLimitX() - strWidth - 6, this.dim.getCenterY() - 4, -1);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.cycleControl(class_388.method_1042());
                this.playClickSound();
                return true;
            }
            return false;
        }

        @Override
        public boolean keyPressed(int keyCode, char scanCode) {
            if (!this.isFocused()) {
                return false;
            }
            if (CommonInputs.selected(keyCode)) {
                this.cycleControl(class_388.method_1042());
                return true;
            }
            return false;
        }

        public void cycleControl(boolean reverse) {
            this.currentIndex = reverse ? (this.currentIndex + this.allowedValues.length - 1) % this.allowedValues.length : (this.currentIndex + 1) % this.allowedValues.length;
            this.option.setValue(this.allowedValues[this.currentIndex]);
        }
    }
}

