/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import dev.vexor.radium.compat.mojang.minecraft.gui.draw.Rect2i;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1442;
import net.minecraft.class_1982;
import net.minecraft.class_1986;
import net.minecraft.class_837;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 170;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Rect2i sliderBounds;
        private int contentWidth;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int max;
        private final int range;
        private final int interval;
        private double thumbPosition;
        private boolean sliderHeld;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.max = max;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new Rect2i(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
            this.sliderHeld = false;
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            int sliderX = this.sliderBounds.getX();
            int sliderY = this.sliderBounds.getY();
            int sliderWidth = this.sliderBounds.getWidth();
            int sliderHeight = this.sliderBounds.getHeight();
            class_1982 label = this.formatter.format((Integer)this.option.getValue()).method_7474();
            if (!this.option.isAvailable()) {
                label.method_7468(new class_1986().method_7486(class_1442.field_5490).method_7498(Boolean.valueOf(true)));
            }
            int labelWidth = this.font.method_954(label.method_7472());
            boolean drawSlider = this.option.isAvailable() && (this.hovered || this.isFocused());
            this.contentWidth = drawSlider ? sliderWidth + labelWidth : labelWidth;
            super.render(mouseX, mouseY, delta);
            if (drawSlider) {
                this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
                double thumbOffset = class_837.method_8339((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
                int thumbX = (int)((double)sliderX + thumbOffset - 2.0);
                int trackY = (int)((double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5);
                this.drawRect(thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
                this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
                this.drawString(label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
            } else {
                this.drawString(label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
            }
        }

        @Override
        public int getContentWidth() {
            return this.contentWidth;
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.sliderHeld = false;
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                if (this.sliderBounds.contains((int)mouseX, (int)mouseY)) {
                    this.setValueFromMouse(mouseX);
                    this.sliderHeld = true;
                }
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.getX()) / (double)this.sliderBounds.getWidth());
        }

        public void setValue(double d) {
            this.thumbPosition = class_837.method_8339((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        @Override
        public boolean keyPressed(int keyCode, char scanCode) {
            if (!this.isFocused()) {
                return false;
            }
            if (keyCode == 203) {
                this.option.setValue(class_837.method_2339((int)((Integer)this.option.getValue() - this.interval), (int)this.min, (int)this.max));
                return true;
            }
            if (keyCode == 205) {
                this.option.setValue(class_837.method_2339((int)((Integer)this.option.getValue() + this.interval), (int)this.min, (int)this.max));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseDragged(double d, double d2, int n) {
            if (this.option.isAvailable() && n == 0) {
                if (this.sliderHeld) {
                    this.setValueFromMouse(d);
                }
                return true;
            }
            return false;
        }
    }
}

