/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobQueue;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.minecraft.class_478;
import net.minecraft.class_837;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkBuilder {
    static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private final ChunkJobQueue queue = new ChunkJobQueue();
    private final List<Thread> threads = new ArrayList<Thread>();
    private final AtomicInteger busyThreadCount = new AtomicInteger();
    private final ChunkBuildContext localContext;

    public ChunkBuilder(class_478 level, ChunkVertexType vertexType) {
        int count = ChunkBuilder.getThreadCount();
        for (int i = 0; i < count; ++i) {
            ChunkBuildContext context = new ChunkBuildContext(level, vertexType);
            WorkerRunnable worker = new WorkerRunnable("Chunk Render Task Executor #" + i, context);
            Thread thread = new Thread((Runnable)worker, "Chunk Render Task Executor #" + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", new Object[]{this.threads.size()});
        this.localContext = new ChunkBuildContext(level, vertexType);
    }

    public long getTotalRemainingDuration(long durationPerThread) {
        return Math.max(0L, (long)this.threads.size() * durationPerThread - this.queue.getJobDurationSum());
    }

    public void shutdown() {
        if (!this.queue.isRunning()) {
            throw new IllegalStateException("Worker threads are not running");
        }
        Collection<ChunkJob> jobs = this.queue.shutdown();
        for (ChunkJob job : jobs) {
            job.setCancelled();
        }
        this.shutdownThreads();
    }

    private void shutdownThreads() {
        LOGGER.info("Stopping worker threads");
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
    }

    public <TASK extends ChunkBuilderTask<OUTPUT>, OUTPUT extends BuilderTaskOutput> ChunkJobTyped<TASK, OUTPUT> scheduleTask(TASK task, boolean important, Consumer<ChunkJobResult<OUTPUT>> consumer, boolean blocking) {
        Validate.notNull(task, (String)"Task must be non-null", (Object[])new Object[0]);
        if (!this.queue.isRunning()) {
            throw new IllegalStateException("Executor is stopped");
        }
        ChunkJobTyped<TASK, OUTPUT> job = new ChunkJobTyped<TASK, OUTPUT>(task, consumer, blocking);
        this.queue.add(job, important);
        return job;
    }

    private static int getOptimalThreadCount() {
        return class_837.method_2339((int)Math.max(ChunkBuilder.getMaxThreadCount() / 3, ChunkBuilder.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getThreadCount() {
        int requested = SodiumClientMod.options().performance.chunkBuilderThreads;
        return requested == 0 ? ChunkBuilder.getOptimalThreadCount() : Math.min(requested, ChunkBuilder.getMaxThreadCount());
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public void tryStealTask(ChunkJob job) {
        if (!this.queue.stealJob(job)) {
            return;
        }
        ChunkBuildContext localContext = this.localContext;
        try {
            job.execute(localContext);
        }
        finally {
            localContext.cleanup();
        }
    }

    public boolean isBuildQueueEmpty() {
        return this.queue.isEmpty();
    }

    public int getScheduledJobCount() {
        return this.queue.size();
    }

    public float getBusyFraction(long frameDuration) {
        return (float)this.queue.getJobDurationSum() / (float)(frameDuration * (long)this.threads.size());
    }

    public int getBusyThreadCount() {
        return this.busyThreadCount.get();
    }

    public int getTotalThreadCount() {
        return this.threads.size();
    }

    private class WorkerRunnable
    implements Runnable {
        private final String name;
        private final ChunkBuildContext context;

        public WorkerRunnable(String name, ChunkBuildContext context) {
            this.name = name;
            this.context = context;
        }

        @Override
        public void run() {
            while (ChunkBuilder.this.queue.isRunning()) {
                ChunkJob job;
                try {
                    job = ChunkBuilder.this.queue.waitForNextJob();
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (job == null) continue;
                ChunkBuilder.this.busyThreadCount.getAndIncrement();
                try {
                    job.execute(this.context);
                }
                finally {
                    this.context.cleanup();
                    ChunkBuilder.this.busyThreadCount.decrementAndGet();
                }
            }
        }
    }
}

