/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.executor;

import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.JobEffort;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;

public class ChunkJobTyped<TASK extends ChunkBuilderTask<OUTPUT>, OUTPUT extends BuilderTaskOutput>
implements ChunkJob {
    private final TASK task;
    private final Consumer<ChunkJobResult<OUTPUT>> consumer;
    private final boolean blocking;
    private volatile boolean cancelled;
    private volatile boolean started;

    ChunkJobTyped(TASK task, Consumer<ChunkJobResult<OUTPUT>> consumer, boolean blocking) {
        this.task = task;
        this.consumer = consumer;
        this.blocking = blocking;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
    }

    @Override
    public void execute(ChunkBuildContext context) {
        ChunkJobResult result;
        if (this.cancelled) {
            return;
        }
        this.started = true;
        try {
            long start = System.nanoTime();
            Object output = ((ChunkBuilderTask)this.task).execute(context, this);
            if (output == null) {
                return;
            }
            result = ChunkJobResult.successfully(output, JobEffort.untilNowWithEffort(this.task.getClass(), start, ((BuilderTaskOutput)output).getResultSize()));
        }
        catch (Throwable throwable) {
            result = ChunkJobResult.exceptionally(throwable);
            ChunkBuilder.LOGGER.error("Chunk build failed", throwable);
        }
        try {
            this.consumer.accept(result);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception while consuming result", throwable);
        }
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public long getEstimatedSize() {
        return ((ChunkBuilderTask)this.task).getEstimatedSize();
    }

    @Override
    public long getEstimatedDuration() {
        return ((ChunkBuilderTask)this.task).getEstimatedDuration();
    }

    @Override
    public long getEstimatedUploadDuration() {
        return ((ChunkBuilderTask)this.task).getEstimatedUploadDuration();
    }
}

