/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.fluid;

import dev.vexor.radium.compat.mojang.math.Mth;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuad;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadViewMutable;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.class_1158;
import net.minecraft.class_1354;
import net.minecraft.class_153;
import net.minecraft.class_154;
import net.minecraft.class_1600;
import net.minecraft.class_1639;
import net.minecraft.class_2232;
import net.minecraft.class_2247;
import net.minecraft.class_236;
import net.minecraft.class_2552;
import net.minecraft.class_63;
import net.minecraft.class_837;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class DefaultFluidRenderer {
    public static final float EPSILON = 0.001f;
    private static final float ALIGNED_EQUALS_EPSILON = 0.011f;
    private final MutableFloat scratchHeight = new MutableFloat(0.0f);
    private final MutableInt scratchSamples = new MutableInt();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final float[] brightness = new float[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();

    public DefaultFluidRenderer(LightPipelineProvider lighters) {
        this.quad.setLightFace(class_1354.field_5201);
        this.lighters = lighters;
    }

    private boolean isFluidOccluded(class_1158 world, class_2552 blockPos, class_1354 dir, class_153 fluid) {
        return !fluid.method_8654(world, blockPos.method_10490(dir), dir);
    }

    public void render(LevelSlice level, class_2232 fluidState, class_2552 blockPos, class_2552 offset, TranslucentGeometryCollector collector, ChunkModelBuilder meshBuilder, Material material, ColorProvider colorProvider, class_1639[] sprites) {
        float northEastHeight;
        float southEastHeight;
        float southWestHeight;
        float northWestHeight;
        class_153 fluid = (class_153)fluidState.method_9028();
        boolean cullUp = this.isFluidOccluded(level, blockPos, class_1354.field_5201, fluid);
        boolean cullDown = this.isFluidOccluded(level, blockPos, class_1354.field_5200, fluid);
        boolean cullNorth = this.isFluidOccluded(level, blockPos, class_1354.field_5202, fluid);
        boolean cullSouth = this.isFluidOccluded(level, blockPos, class_1354.field_5203, fluid);
        boolean cullWest = this.isFluidOccluded(level, blockPos, class_1354.field_5205, fluid);
        boolean cullEast = this.isFluidOccluded(level, blockPos, class_1354.field_5204, fluid);
        if (cullUp && cullDown && cullEast && cullWest && cullNorth && cullSouth) {
            return;
        }
        boolean isWater = fluid.method_6456() == class_63.field_129;
        float fluidHeight = this.fluidHeight(level, fluid, blockPos, class_1354.field_5201);
        if (fluidHeight >= 1.0f) {
            northWestHeight = 1.0f;
            southWestHeight = 1.0f;
            southEastHeight = 1.0f;
            northEastHeight = 1.0f;
        } else {
            float heightNorth = this.fluidHeight(level, fluid, blockPos.method_10490(class_1354.field_5202), class_1354.field_5202);
            float heightSouth = this.fluidHeight(level, fluid, blockPos.method_10490(class_1354.field_5203), class_1354.field_5203);
            float heightEast = this.fluidHeight(level, fluid, blockPos.method_10490(class_1354.field_5204), class_1354.field_5204);
            float heightWest = this.fluidHeight(level, fluid, blockPos.method_10490(class_1354.field_5205), class_1354.field_5205);
            northWestHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightNorth, heightWest, blockPos.method_10490(class_1354.field_5202).method_10490(class_1354.field_5205));
            southWestHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightSouth, heightWest, blockPos.method_10490(class_1354.field_5203).method_10490(class_1354.field_5205));
            southEastHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightSouth, heightEast, blockPos.method_10490(class_1354.field_5203).method_10490(class_1354.field_5204));
            northEastHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightNorth, heightEast, blockPos.method_10490(class_1354.field_5202).method_10490(class_1354.field_5204));
        }
        float yOffset = cullDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && class_1600.method_2963() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        class_154 flow = class_153.method_8816((class_63)fluid.method_6456());
        if (!cullUp) {
            boolean creaseNorthEastSouthWest;
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            class_1639 sprite;
            northWestHeight -= 0.001f;
            southWestHeight -= 0.001f;
            southEastHeight -= 0.001f;
            northEastHeight -= 0.001f;
            class_236 velocity = flow.method_8823((class_1158)level, blockPos);
            if (velocity.field_605 == 0.0 && velocity.field_607 == 0.0) {
                sprite = sprites[0];
                u1 = sprite.method_5341(0.0);
                v1 = sprite.method_5343(0.0);
                u2 = u1;
                v2 = sprite.method_5343(16.0);
                u3 = sprite.method_5341(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                float dir = (float)class_837.method_10842((double)velocity.field_607, (double)velocity.field_605) - 1.5707964f;
                float sin = class_837.method_2335((float)dir) * 0.25f;
                float cos = class_837.method_2344((float)dir) * 0.25f;
                u1 = sprite.method_5341((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.method_5343((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.method_5341((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.method_5343((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.method_5341((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.method_5343((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.method_5341((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.method_5343((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].method_5340() / (sprites[0].method_5345() - sprites[0].method_5344());
            float s2 = (float)sprites[0].method_5342() / (sprites[0].method_5347() - sprites[0].method_5346());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = Mth.lerp(s3, u1, uAvg);
            u2 = Mth.lerp(s3, u2, uAvg);
            u3 = Mth.lerp(s3, u3, uAvg);
            u4 = Mth.lerp(s3, u4, uAvg);
            v1 = Mth.lerp(s3, v1, vAvg);
            v2 = Mth.lerp(s3, v2, vAvg);
            v3 = Mth.lerp(s3, v3, vAvg);
            v4 = Mth.lerp(s3, v4, vAvg);
            quad.setSprite(sprite);
            boolean aligned = DefaultFluidRenderer.isAlignedEquals(northEastHeight, northWestHeight) && DefaultFluidRenderer.isAlignedEquals(northWestHeight, southEastHeight) && DefaultFluidRenderer.isAlignedEquals(southEastHeight, southWestHeight) && DefaultFluidRenderer.isAlignedEquals(southWestHeight, northEastHeight);
            boolean bl = creaseNorthEastSouthWest = aligned || northEastHeight > northWestHeight && northEastHeight > southEastHeight || northEastHeight < northWestHeight && northEastHeight < southEastHeight || southWestHeight > northWestHeight && southWestHeight > southEastHeight || southWestHeight < northWestHeight && southWestHeight < southEastHeight;
            if (creaseNorthEastSouthWest) {
                DefaultFluidRenderer.setVertex(quad, 1, 0.0f, northWestHeight, 0.0f, u1, v1);
                DefaultFluidRenderer.setVertex(quad, 2, 0.0f, southWestHeight, 1.0f, u2, v2);
                DefaultFluidRenderer.setVertex(quad, 3, 1.0f, southEastHeight, 1.0f, u3, v3);
                DefaultFluidRenderer.setVertex(quad, 0, 1.0f, northEastHeight, 0.0f, u4, v4);
            } else {
                DefaultFluidRenderer.setVertex(quad, 0, 0.0f, northWestHeight, 0.0f, u1, v1);
                DefaultFluidRenderer.setVertex(quad, 1, 0.0f, southWestHeight, 1.0f, u2, v2);
                DefaultFluidRenderer.setVertex(quad, 2, 1.0f, southEastHeight, 1.0f, u3, v3);
                DefaultFluidRenderer.setVertex(quad, 3, 1.0f, northEastHeight, 0.0f, u4, v4);
            }
            this.updateQuad(quad, level, blockPos, lighter, class_1354.field_5201, ModelQuadFacing.POS_Y, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, aligned ? ModelQuadFacing.POS_Y : ModelQuadFacing.UNASSIGNED, false);
            if (fluid.method_8822((class_1158)level, blockPos.method_10485())) {
                this.writeQuad(meshBuilder, collector, material, offset, quad, aligned ? ModelQuadFacing.NEG_Y : ModelQuadFacing.UNASSIGNED, true);
            }
        }
        if (!cullDown) {
            class_1639 sprite = sprites[0];
            float minU = sprite.method_5344();
            float maxU = sprite.method_5345();
            float minV = sprite.method_5346();
            float maxV = sprite.method_5347();
            quad.setSprite(sprite);
            DefaultFluidRenderer.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            DefaultFluidRenderer.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            DefaultFluidRenderer.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            DefaultFluidRenderer.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.updateQuad(quad, level, blockPos, lighter, class_1354.field_5200, ModelQuadFacing.NEG_Y, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, ModelQuadFacing.NEG_Y, false);
        }
        quad.setFlags(6);
        block6: for (class_1354 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case field_5202: {
                    if (cullNorth) continue block6;
                    c1 = northWestHeight;
                    c2 = northEastHeight;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case field_5203: {
                    if (cullSouth) continue block6;
                    c1 = southEastHeight;
                    c2 = southWestHeight;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case field_5205: {
                    if (cullWest) continue block6;
                    c1 = southWestHeight;
                    c2 = northWestHeight;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case field_5204: {
                    if (cullEast) continue block6;
                    c1 = northEastHeight;
                    c2 = southEastHeight;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (fluid.method_8654((class_1158)level, blockPos, dir)) continue;
            class_1639 sprite = sprites[1];
            float u1 = sprite.method_5341(0.0);
            float u2 = sprite.method_5341(8.0);
            float v1 = sprite.method_5343((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.method_5343((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.method_5343(8.0);
            quad.setSprite(sprite);
            DefaultFluidRenderer.setVertex(quad, 0, x2, c2, z2, u2, v2);
            DefaultFluidRenderer.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            DefaultFluidRenderer.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            DefaultFluidRenderer.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.method_10538() == class_1354.class_2558.field_11467 ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.updateQuad(quad, level, blockPos, lighter, dir, facing, br, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, facing, false);
            this.writeQuad(meshBuilder, collector, material, offset, quad, facing.getOpposite(), true);
        }
    }

    private static boolean isAlignedEquals(float a, float b) {
        return Math.abs(a - b) <= 0.011f;
    }

    private void updateQuad(ModelQuadViewMutable quad, LevelSlice level, class_2552 pos, LightPipeline lighter, class_1354 dir, ModelQuadFacing facing, float brightness, ColorProvider colorProvider, class_2232 fluidState) {
        int normal = facing.isAligned() ? facing.getPackedAlignedNormal() : quad.calculateNormal();
        quad.setFaceNormal(normal);
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false, false);
        if (colorProvider != null && quad.method_9980()) {
            colorProvider.getColors(level, fluidState, quad, this.quadColors, pos);
        } else {
            Arrays.fill(this.quadColors, 0xFFFFFF);
        }
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorARGB.toABGR(this.quadColors[i]) | 0xFF000000;
            this.brightness[i] = light.br[i] * brightness;
        }
    }

    private void writeQuad(ChunkModelBuilder builder, TranslucentGeometryCollector collector, Material material, class_2552 offset, ModelQuadView quad, ModelQuadFacing facing, boolean flip) {
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[flip ? 3 - i + 1 & 3 : i];
            out.x = (float)offset.method_10572() + quad.getX(i);
            out.y = (float)offset.method_10573() + quad.getY(i);
            out.z = (float)offset.method_10574() + quad.getZ(i);
            out.color = this.quadColors[i];
            out.ao = this.brightness[i];
            out.u = quad.getTexU(i);
            out.v = quad.getTexV(i);
            out.light = this.quadLightData.lm[i];
        }
        class_1639 sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        if (material.isTranslucent() && collector != null) {
            int normal = facing.isAligned() ? facing.getPackedAlignedNormal() : quad.getFaceNormal();
            if (flip) {
                normal = NormI8.flipPacked(normal);
            }
            if (collector.appendQuad(vertices, facing, normal)) {
                return;
            }
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(facing);
        vertexBuffer.push(vertices, material);
    }

    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float fluidCornerHeight(class_1158 world, class_153 fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, class_2552 blockPos) {
        if (fluidHeightY >= 1.0f || fluidHeightX >= 1.0f) {
            return 1.0f;
        }
        if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
            float height = this.fluidHeight(world, fluid, blockPos, class_1354.field_5201);
            if (height >= 1.0f) {
                return 1.0f;
            }
            this.modifyHeight(this.scratchHeight, this.scratchSamples, height);
        }
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeight);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightY);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightX);
        float result = this.scratchHeight.floatValue() / (float)this.scratchSamples.intValue();
        this.scratchHeight.setValue(0.0f);
        this.scratchSamples.setValue(0);
        return result;
    }

    private void modifyHeight(MutableFloat totalHeight, MutableInt samples, float target) {
        if (target >= 0.8f) {
            totalHeight.add(target * 10.0f);
            samples.add(10);
        } else if (target >= 0.0f) {
            totalHeight.add(target);
            samples.increment();
        }
    }

    private float fluidHeight(class_1158 world, class_153 fluid, class_2552 blockPos, class_1354 direction) {
        class_2232 blockState = world.method_8580(blockPos);
        if (blockState.method_9028().method_6456() == fluid.method_6456()) {
            class_2232 fluidStateUp = world.method_8580(blockPos.method_10485());
            if (fluidStateUp.method_9028().method_6456() == fluid.method_6456()) {
                return 1.0f;
            }
            try {
                return 1.0f - class_153.method_330((int)((Integer)blockState.method_9027((class_2247)class_153.field_9523)));
            }
            catch (Exception e) {
                return 0.0f;
            }
        }
        if (!blockState.method_9028().method_6451()) {
            return 0.0f;
        }
        return -1.0f;
    }
}

