/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPSortState;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPWorkspace;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerPartitionBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.Partition;
import org.joml.Vector3fc;

class InnerBinaryPartitionBSPNode
extends InnerPartitionBSPNode {
    private final float planeDistance;
    private final BSPNode inside;
    private final BSPNode outside;
    private final int[] onPlaneQuads;

    InnerBinaryPartitionBSPNode(InnerPartitionBSPNode.NodeReuseData reuseData, float planeDistance, int axis, BSPNode inside, BSPNode outside, int[] onPlaneQuads) {
        super(reuseData, axis);
        this.planeDistance = planeDistance;
        this.inside = inside;
        this.outside = outside;
        this.onPlaneQuads = onPlaneQuads;
    }

    InnerBinaryPartitionBSPNode(InnerPartitionBSPNode.NodeReuseData reuseData, float planeDistance, Vector3fc planeNormal, BSPNode inside, BSPNode outside, int[] onPlaneQuads) {
        super(reuseData, planeNormal);
        this.planeDistance = planeDistance;
        this.inside = inside;
        this.outside = outside;
        this.onPlaneQuads = onPlaneQuads;
    }

    @Override
    void addPartitionPlanes(BSPWorkspace workspace) {
        if (this.axis == -1) {
            workspace.addUnalignedPartitionPlane(this.planeNormal, this.planeDistance);
        } else {
            workspace.addAlignedPartitionPlane(this.axis, this.planeDistance);
        }
        BSPNode bSPNode = this.inside;
        if (bSPNode instanceof InnerPartitionBSPNode) {
            InnerPartitionBSPNode insideChild = (InnerPartitionBSPNode)bSPNode;
            insideChild.addPartitionPlanes(workspace);
        }
        if ((bSPNode = this.outside) instanceof InnerPartitionBSPNode) {
            InnerPartitionBSPNode outsideChild = (InnerPartitionBSPNode)bSPNode;
            outsideChild.addPartitionPlanes(workspace);
        }
    }

    private void collectInside(BSPSortState sortState, Vector3fc cameraPos) {
        if (this.inside != null) {
            this.inside.collectSortedQuads(sortState, cameraPos);
        }
    }

    private void collectOutside(BSPSortState sortState, Vector3fc cameraPos) {
        if (this.outside != null) {
            this.outside.collectSortedQuads(sortState, cameraPos);
        }
    }

    @Override
    void collectSortedQuads(BSPSortState sortState, Vector3fc cameraPos) {
        boolean cameraInside;
        sortState.startNode(this);
        boolean bl = cameraInside = this.planeNormal.dot(cameraPos) < this.planeDistance;
        if (cameraInside) {
            this.collectOutside(sortState, cameraPos);
        } else {
            this.collectInside(sortState, cameraPos);
        }
        if (this.onPlaneQuads != null) {
            sortState.writeIndexes(this.onPlaneQuads);
        }
        if (cameraInside) {
            this.collectInside(sortState, cameraPos);
        } else {
            this.collectOutside(sortState, cameraPos);
        }
    }

    static BSPNode buildFromPartitions(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode, Partition inside, Partition outside, int axis) {
        float partitionDistance = inside.distance();
        workspace.addAlignedPartitionPlane(axis, partitionDistance);
        BSPNode oldInsideNode = null;
        BSPNode oldOutsideNode = null;
        if (oldNode instanceof InnerBinaryPartitionBSPNode) {
            InnerBinaryPartitionBSPNode binaryNode = (InnerBinaryPartitionBSPNode)oldNode;
            if (binaryNode.axis == axis && binaryNode.planeDistance == partitionDistance) {
                oldInsideNode = binaryNode.inside;
                oldOutsideNode = binaryNode.outside;
            }
        }
        BSPNode insideNode = null;
        BSPNode outsideNode = null;
        if (inside.quadsBefore() != null) {
            insideNode = BSPNode.build(workspace, inside.quadsBefore(), depth, oldInsideNode);
        }
        if (outside != null) {
            outsideNode = BSPNode.build(workspace, outside.quadsBefore(), depth, oldOutsideNode);
        }
        int[] onPlane = inside.quadsOn() == null ? null : BSPSortState.compressIndexes(inside.quadsOn());
        return new InnerBinaryPartitionBSPNode(InnerBinaryPartitionBSPNode.prepareNodeReuse(workspace, indexes, depth), partitionDistance, axis, insideNode, outsideNode, onPlane);
    }

    static BSPNode buildFromParts(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode, IntArrayList inside, IntArrayList outside, IntArrayList onPlane, int axis, Vector3fc planeNormal, float partitionDistance) {
        if (axis == -1) {
            workspace.addUnalignedPartitionPlane(planeNormal, partitionDistance);
        } else {
            workspace.addAlignedPartitionPlane(axis, Math.abs(partitionDistance));
        }
        BSPNode oldInsideNode = null;
        BSPNode oldOutsideNode = null;
        if (oldNode instanceof InnerBinaryPartitionBSPNode) {
            InnerBinaryPartitionBSPNode binaryNode = (InnerBinaryPartitionBSPNode)oldNode;
            if (binaryNode.axis == axis && (axis == -1 || binaryNode.planeNormal.equals(planeNormal)) && binaryNode.planeDistance == partitionDistance) {
                oldInsideNode = binaryNode.inside;
                oldOutsideNode = binaryNode.outside;
            }
        }
        BSPNode insideNode = null;
        BSPNode outsideNode = null;
        if (inside != null) {
            insideNode = BSPNode.build(workspace, inside, depth, oldInsideNode);
        }
        if (outside != null) {
            outsideNode = BSPNode.build(workspace, outside, depth, oldOutsideNode);
        }
        int[] onPlaneArr = BSPSortState.compressIndexes(onPlane);
        return new InnerBinaryPartitionBSPNode(InnerBinaryPartitionBSPNode.prepareNodeReuse(workspace, indexes, depth), partitionDistance, planeNormal, insideNode, outsideNode, onPlaneArr);
    }
}

