/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.TraversableTree;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.Tree;

public class RemovableTree
extends TraversableTree {
    private boolean reducedIsValid = true;
    private int sortKey;

    public RemovableTree(int offsetX, int offsetY, int offsetZ) {
        super(offsetX, offsetY, offsetZ);
    }

    public boolean remove(int x, int y, int z) {
        if (Tree.isOutOfBounds(x -= this.offsetX, y -= this.offsetY, z -= this.offsetZ)) {
            return false;
        }
        int bitIndex = Tree.interleave6x3(x, y, z);
        int n = bitIndex >> 6;
        this.tree[n] = this.tree[n] & (1L << (bitIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        this.reducedIsValid = false;
        return true;
    }

    @Override
    public void prepareForTraversal() {
        if (!this.reducedIsValid) {
            super.prepareForTraversal();
            this.reducedIsValid = true;
        }
    }

    @Override
    public boolean add(int x, int y, int z) {
        boolean result = super.add(x, y, z);
        if (result) {
            this.reducedIsValid = false;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.treeDoubleReduced == 0L;
    }

    public long getTreeKey() {
        return SectionPos.asLong(this.offsetX, this.offsetY, this.offsetZ);
    }

    public void updateSortKeyFor(int cameraSectionX, int cameraSectionY, int cameraSectionZ) {
        int deltaX = Math.abs(this.offsetX + 32 - cameraSectionX);
        int deltaY = Math.abs(this.offsetY + 32 - cameraSectionY);
        int deltaZ = Math.abs(this.offsetZ + 32 - cameraSectionZ);
        this.sortKey = deltaX + deltaY + deltaZ + 1;
    }

    public int getSortKey() {
        return this.sortKey;
    }

    @Override
    public int getPresence(int i, int i1, int i2) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

