/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.helper;

import dev.vexor.radium.frapi.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.class_1354;
import net.minecraft.class_1639;

public class TextureHelper {
    private static final float NORMALIZER = 0.0625f;
    private static final VertexModifier[] ROTATIONS = new VertexModifier[]{null, (q, i) -> q.uv(i, q.v(i), 1.0f - q.u(i)), (q, i) -> q.uv(i, 1.0f - q.u(i), 1.0f - q.v(i)), (q, i) -> q.uv(i, 1.0f - q.v(i), q.u(i))};
    private static final VertexModifier[] UVLOCKERS = new VertexModifier[6];

    private TextureHelper() {
    }

    public static void bakeSprite(MutableQuadView quad, class_1639 sprite, int bakeFlags) {
        if (quad.nominalFace() != null && (4 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, UVLOCKERS[quad.nominalFace().method_10524()]);
        } else if ((0x20 & bakeFlags) == 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.uv(i, q.u(i) * 0.0625f, q.v(i) * 0.0625f));
        }
        int rotation = bakeFlags & 3;
        if (rotation != 0) {
            TextureHelper.applyModifier(quad, ROTATIONS[rotation]);
        }
        if ((8 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.uv(i, 1.0f - q.u(i), q.v(i)));
        }
        if ((0x10 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.uv(i, q.u(i), 1.0f - q.v(i)));
        }
        TextureHelper.interpolate(quad, sprite);
    }

    private static void interpolate(MutableQuadView q, class_1639 sprite) {
        float uMin = sprite.method_5344();
        float uSpan = sprite.method_5345() - uMin;
        float vMin = sprite.method_5346();
        float vSpan = sprite.method_5347() - vMin;
        for (int i = 0; i < 4; ++i) {
            q.uv(i, uMin + q.u(i) * uSpan, vMin + q.v(i) * vSpan);
        }
    }

    private static void applyModifier(MutableQuadView quad, VertexModifier modifier) {
        for (int i = 0; i < 4; ++i) {
            modifier.apply(quad, i);
        }
    }

    static {
        TextureHelper.UVLOCKERS[class_1354.field_5204.method_10524()] = (q, i) -> q.uv(i, 1.0f - q.z(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_1354.field_5205.method_10524()] = (q, i) -> q.uv(i, q.z(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_1354.field_5202.method_10524()] = (q, i) -> q.uv(i, 1.0f - q.x(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_1354.field_5203.method_10524()] = (q, i) -> q.uv(i, q.x(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_1354.field_5200.method_10524()] = (q, i) -> q.uv(i, q.x(i), 1.0f - q.z(i));
        TextureHelper.UVLOCKERS[class_1354.field_5201.method_10524()] = (q, i) -> q.uv(i, q.x(i), q.z(i));
    }

    @FunctionalInterface
    private static interface VertexModifier {
        public void apply(MutableQuadView var1, int var2);
    }
}

