/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.material;

import dev.vexor.radium.frapi.api.renderer.v1.material.BlendMode;
import dev.vexor.radium.frapi.api.renderer.v1.material.MaterialFinder;
import dev.vexor.radium.frapi.api.renderer.v1.material.RenderMaterial;
import dev.vexor.radium.frapi.api.renderer.v1.material.ShadeMode;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.render.frapi.material.MaterialViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.legacyfabric.fabric.api.util.TriState;

public class MaterialFinderImpl
extends MaterialViewImpl
implements MaterialFinder {
    private static int defaultBits = 0;

    public MaterialFinderImpl() {
        super(defaultBits);
    }

    @Override
    public MaterialFinder blendMode(BlendMode blendMode) {
        Objects.requireNonNull(blendMode, "BlendMode may not be null");
        this.bits = this.bits & ~BLEND_MODE_MASK | blendMode.ordinal() << 0;
        return this;
    }

    @Override
    public MaterialFinder emissive(boolean isEmissive) {
        this.bits = isEmissive ? this.bits | EMISSIVE_FLAG : this.bits & ~EMISSIVE_FLAG;
        return this;
    }

    @Override
    public MaterialFinder disableDiffuse(boolean disable) {
        this.bits = disable ? this.bits | DIFFUSE_FLAG : this.bits & ~DIFFUSE_FLAG;
        return this;
    }

    @Override
    public MaterialFinder ambientOcclusion(TriState mode) {
        Objects.requireNonNull(mode, "ambient occlusion TriState may not be null");
        this.bits = this.bits & ~AO_MASK | mode.ordinal() << AO_BIT_OFFSET;
        return this;
    }

    @Override
    public MaterialFinder shadeMode(ShadeMode mode) {
        Objects.requireNonNull(mode, "ShadeMode may not be null");
        this.bits = this.bits & ~SHADE_MODE_MASK | mode.ordinal() << SHADE_MODE_BIT_OFFSET;
        return this;
    }

    @Override
    public MaterialFinder clear() {
        this.bits = defaultBits;
        return this;
    }

    @Override
    public RenderMaterial find() {
        return RenderMaterialImpl.byIndex(this.bits);
    }

    static {
        MaterialFinderImpl finder = new MaterialFinderImpl();
        finder.ambientOcclusion(TriState.DEFAULT);
        finder.shadeMode(ShadeMode.ENHANCED);
        defaultBits = finder.bits;
        if (!MaterialFinderImpl.areBitsValid(defaultBits)) {
            throw new AssertionError((Object)"Default MaterialFinder bits are not valid!");
        }
    }
}

