/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadView;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.GeometryHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.NormalHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.minecraft.class_1354;
import net.minecraft.class_1639;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class QuadViewImpl
implements QuadView,
ModelQuadView {
    @Nullable
    protected class_1354 nominalFace;
    protected boolean isGeometryInvalid = true;
    protected final Vector3f faceNormal = new Vector3f();
    protected int[] data;
    protected int baseIndex = 0;

    public void load() {
        this.isGeometryInvalid = false;
        this.nominalFace = this.lightFace();
        NormI8.unpack(this.packedFaceNormal(), this.faceNormal);
    }

    protected void computeGeometry() {
        if (this.isGeometryInvalid) {
            int packedFaceNormal;
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.data[this.baseIndex + 1] = packedFaceNormal = NormI8.pack(this.faceNormal);
            class_1354 lightFace = GeometryHelper.lightFace(this);
            this.data[this.baseIndex + 0] = EncodingFormat.lightFace(this.data[this.baseIndex + 0], lightFace);
            this.data[this.baseIndex + 0] = EncodingFormat.normalFace(this.data[this.baseIndex + 0], ModelQuadFacing.fromPackedNormal(packedFaceNormal));
            this.data[this.baseIndex + 0] = EncodingFormat.geometryFlags(this.data[this.baseIndex + 0], ModelQuadFlags.getQuadFlags(this, lightFace));
        }
    }

    public int geometryFlags() {
        this.computeGeometry();
        return EncodingFormat.geometryFlags(this.data[this.baseIndex + 0]);
    }

    public boolean hasShade() {
        return !this.material().disableDiffuse();
    }

    @Override
    public float x(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X]);
    }

    @Override
    public float y(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Y]);
    }

    @Override
    public float z(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Z]);
    }

    @Override
    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X + coordinateIndex]);
    }

    @Override
    public int color(int vertexIndex) {
        return this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR];
    }

    @Override
    public float u(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U]);
    }

    @Override
    public float v(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_V]);
    }

    @Override
    public int lightmap(int vertexIndex) {
        return this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP];
    }

    public int normalFlags() {
        return EncodingFormat.normalFlags(this.data[this.baseIndex + 0]);
    }

    @Override
    public boolean hasNormal(int vertexIndex) {
        return (this.normalFlags() & 1 << vertexIndex) != 0;
    }

    protected final int normalIndex(int vertexIndex) {
        return this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL;
    }

    @Override
    @Nullable
    public final class_1354 cullFace() {
        return EncodingFormat.cullFace(this.data[this.baseIndex + 0]);
    }

    @Override
    @NotNull
    public final class_1354 lightFace() {
        this.computeGeometry();
        return EncodingFormat.lightFace(this.data[this.baseIndex + 0]);
    }

    public final ModelQuadFacing normalFace() {
        this.computeGeometry();
        return EncodingFormat.normalFace(this.data[this.baseIndex + 0]);
    }

    @Override
    @Nullable
    public final class_1354 nominalFace() {
        return this.nominalFace;
    }

    public final int packedFaceNormal() {
        this.computeGeometry();
        return this.data[this.baseIndex + 1];
    }

    @Override
    public final Vector3f faceNormal() {
        this.computeGeometry();
        return this.faceNormal;
    }

    @Override
    public final RenderMaterialImpl material() {
        return EncodingFormat.material(this.data[this.baseIndex + 0]);
    }

    @Override
    public final int tintIndex() {
        return this.data[this.baseIndex + 2];
    }

    @Override
    public final int tag() {
        return this.data[this.baseIndex + 3];
    }

    @Override
    public float getX(int idx) {
        return this.x(idx);
    }

    @Override
    public float getY(int idx) {
        return this.y(idx);
    }

    @Override
    public float getZ(int idx) {
        return this.z(idx);
    }

    @Override
    public int getColor(int idx) {
        return ColorHelper.toVanillaColor(this.color(idx));
    }

    @Override
    public float getTexU(int idx) {
        return this.u(idx);
    }

    @Override
    public float getTexV(int idx) {
        return this.v(idx);
    }

    @Override
    public int getVertexNormal(int idx) {
        return this.data[this.normalIndex(idx - 1)];
    }

    @Override
    public int getFaceNormal() {
        return this.packedFaceNormal();
    }

    @Override
    public int getLight(int idx) {
        return this.lightmap(idx);
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex();
    }

    @Override
    public class_1639 getSprite() {
        throw new UnsupportedOperationException("Not available for QuadViewImpl.");
    }

    @Override
    public class_1354 getLightFace() {
        return this.lightFace();
    }

    @Override
    public int getMaxLightQuad(int idx) {
        return this.lightmap(idx);
    }

    @Override
    public int getFlags() {
        return this.geometryFlags();
    }
}

