/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;

public final class ContextGL
implements Context {
    public long glfwWindow = Long.MIN_VALUE;
    public final boolean shared;

    public ContextGL(long glfwWindow, boolean shared) {
        this.glfwWindow = glfwWindow;
        this.shared = shared;
    }

    @Override
    public void releaseCurrent() throws LWJGLException {
        GLFW.glfwMakeContextCurrent(0L);
        GL.setCapabilities(null);
    }

    @Override
    public synchronized void releaseDrawable() throws LWJGLException {
    }

    public synchronized void update() {
    }

    public static void swapBuffers() throws LWJGLException {
        GLFW.glfwSwapBuffers(Display.getWindow());
    }

    @Override
    public synchronized void makeCurrent() throws LWJGLException {
        GLFW.glfwMakeContextCurrent(this.glfwWindow);
        GL.createCapabilities();
    }

    @Override
    public synchronized boolean isCurrent() throws LWJGLException {
        return GLFW.glfwGetCurrentContext() == this.glfwWindow;
    }

    public static void setSwapInterval(int value) {
        GLFW.glfwSwapInterval(value);
    }

    public synchronized void forceDestroy() throws LWJGLException {
        this.destroy();
    }

    public synchronized void destroy() throws LWJGLException {
        if (this.shared && this.glfwWindow > 0L) {
            GLFW.glfwDestroyWindow(this.glfwWindow);
            this.glfwWindow = -1L;
        }
    }

    public synchronized void setCLSharingProperties(PointerBuffer properties) throws LWJGLException {
    }
}

