/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.input.KeyCodes;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean startFullscreen = false;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static DisplayMode desktopDisplayMode = new DisplayMode(854, 480);
    private static int latestEventKey = 0;
    private static int displayX = 0;
    private static int displayY = 0;
    private static boolean displayResized = false;
    private static int displayWidth = 0;
    private static int displayHeight = 0;
    private static int displayFramebufferWidth = 0;
    private static int displayFramebufferHeight = 0;
    private static boolean latestResized = false;
    private static int latestWidth = 0;
    private static int latestHeight = 0;
    private static boolean cancelNextChar = false;
    private static Keyboard.KeyEvent ingredientKeyEvent;
    private static ByteBuffer[] savedIcons;
    private static int[] savedX;
    private static int[] savedY;
    private static int[] savedW;
    private static int[] savedH;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixel_format, Drawable shared_drawable) {
        System.out.println("TODO: Implement Display.create(PixelFormat, Drawable)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format, ContextAttribs attribs) {
        System.out.println("TODO: Implement Display.create(PixelFormat, ContextAttribs)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format) {
        System.out.println("TODO: Implement Display.create(PixelFormat)");
        Display.create();
    }

    public static void create() {
        if (displayCreated) {
            return;
        }
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 1);
        GLFW.glfwWindowHint(131075, 1);
        GLFW.glfwWindowHint(139266, 2);
        GLFW.glfwWindowHint(139267, 1);
        GLFW.glfwWindowHint(143361, 0);
        Window.handle = GLFW.glfwCreateWindow(mode.getWidth(), mode.getHeight(), windowTitle, 0L, 0L);
        if (Window.handle == 0L) {
            throw new IllegalStateException("Failed to create Display window");
        }
        Window.keyCallback = new GLFWKeyCallback(){

            @Override
            public void invoke(long window, int key, int scancode, int action, int mods) {
                cancelNextChar = false;
                if (key > 32 && key <= 96) {
                    if ((2 & mods) != 0 && (4 & mods) == 0) {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        cancelNextChar = true;
                    } else if (action > 0) {
                        ingredientKeyEvent = new Keyboard.KeyEvent(KeyCodes.glfwToLwjgl(key), '\u0000', action > 1 ? Keyboard.KeyState.REPEAT : Keyboard.KeyState.PRESS, Sys.getNanoTime());
                    } else {
                        if (ingredientKeyEvent != null && Display.ingredientKeyEvent.key == KeyCodes.glfwToLwjgl(key)) {
                            Display.ingredientKeyEvent.queueOutOfOrderRelease = true;
                        }
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                    }
                } else {
                    int mappedChar = key == 257 ? 13 : (key == 256 ? 27 : (key == 258 ? 9 : (key == 259 ? 8 : 0)));
                    Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)mappedChar);
                }
            }
        };
        Window.charCallback = new GLFWCharCallback(){

            @Override
            public void invoke(long window, int codepoint) {
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else if (ingredientKeyEvent != null) {
                    Display.ingredientKeyEvent.aChar = (char)codepoint;
                    Keyboard.addRawKeyEvent(ingredientKeyEvent);
                    if (Display.ingredientKeyEvent.queueOutOfOrderRelease) {
                        ingredientKeyEvent = ingredientKeyEvent.copy();
                        Display.ingredientKeyEvent.state = Keyboard.KeyState.RELEASE;
                        Keyboard.addRawKeyEvent(ingredientKeyEvent);
                    }
                    ingredientKeyEvent = null;
                } else {
                    Keyboard.addCharEvent(0, (char)codepoint);
                }
            }
        };
        Window.cursorPosCallback = new GLFWCursorPosCallback(){

            @Override
            public void invoke(long window, double xpos, double ypos) {
                Mouse.addMoveEvent(xpos, ypos);
            }
        };
        Window.mouseButtonCallback = new GLFWMouseButtonCallback(){

            @Override
            public void invoke(long window, int button, int action, int mods) {
                Mouse.addButtonEvent(button, action == 1);
            }
        };
        Window.scrollCallback = new GLFWScrollCallback(){

            @Override
            public void invoke(long window, double xoffset, double yoffset) {
                Mouse.addWheelEvent(yoffset);
            }
        };
        Window.windowFocusCallback = new GLFWWindowFocusCallback(){

            @Override
            public void invoke(long window, boolean focused) {
                displayFocused = focused;
            }
        };
        Window.windowIconifyCallback = new GLFWWindowIconifyCallback(){

            @Override
            public void invoke(long window, boolean iconified) {
                displayVisible = !iconified;
            }
        };
        Window.windowSizeCallback = new GLFWWindowSizeCallback(){

            @Override
            public void invoke(long window, int width, int height) {
                latestResized = true;
                latestWidth = width;
                latestHeight = height;
            }
        };
        Window.windowPosCallback = new GLFWWindowPosCallback(){

            @Override
            public void invoke(long window, int xpos, int ypos) {
                displayX = xpos;
                displayY = ypos;
            }
        };
        Window.windowRefreshCallback = new GLFWWindowRefreshCallback(){

            @Override
            public void invoke(long window) {
                displayDirty = true;
            }
        };
        Window.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            @Override
            public void invoke(long window, int width, int height) {
                displayFramebufferWidth = width;
                displayFramebufferHeight = height;
            }
        };
        Window.setCallbacks();
        displayWidth = mode.getWidth();
        displayHeight = mode.getHeight();
        IntBuffer fbw = BufferUtils.createIntBuffer(1);
        IntBuffer fbh = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize(Window.handle, fbw, fbh);
        displayFramebufferWidth = fbw.get(0);
        displayFramebufferHeight = fbh.get(0);
        displayX = (monitorWidth - mode.getWidth()) / 2;
        displayY = (monitorHeight - mode.getHeight()) / 2;
        GLFW.glfwMakeContextCurrent(Window.handle);
        drawable = new DrawableGL();
        GL.createCapabilities();
        if (savedIcons != null) {
            Display.setIcon(savedIcons);
            savedIcons = null;
        }
        GLFW.glfwSwapInterval(1);
        displayCreated = true;
        if (startFullscreen) {
            Display.setFullscreen(true);
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowSize(Window.handle, x, y);
        Window.windowSizeCallback.invoke(Window.handle, x[0], y[0]);
        GLFW.glfwGetFramebufferSize(Window.handle, x, y);
        Window.framebufferSizeCallback.invoke(Window.handle, x[0], y[0]);
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        System.out.println("TODO: Implement Display.setLocation(int, int)");
    }

    public static void setVSyncEnabled(boolean sync) {
        GLFW.glfwSwapInterval(sync ? 1 : 0);
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers(Window.handle);
    }

    public static void destroy() {
        Window.releaseCallbacks();
        GLFW.glfwDestroyWindow(Window.handle);
        displayCreated = false;
    }

    public static void setDisplayMode(DisplayMode dm) {
        mode = dm;
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        IntBuffer count = BufferUtils.createIntBuffer(1);
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes(GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModes = new DisplayMode[count.get(0)];
        for (int i = 0; i < count.get(0); ++i) {
            modes.position(i * GLFWVidMode.SIZEOF);
            int w = modes.width();
            int h = modes.height();
            int b = modes.redBits() + modes.greenBits() + modes.blueBits();
            int r = modes.refreshRate();
            displayModes[i] = new DisplayMode(w, h, b, r);
        }
        return displayModes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return displayWidth;
    }

    public static int getHeight() {
        return displayHeight;
    }

    public static int getFramebufferWidth() {
        return displayFramebufferWidth;
    }

    public static int getFramebufferHeight() {
        return displayFramebufferHeight;
    }

    public static void setTitle(String title) {
        windowTitle = title;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle(Display.getWindow(), title);
        }
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose(Window.handle);
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.getWindow() == 0L) {
            savedIcons = icons;
            return 0;
        }
        GLFWImage.Buffer glfwImages = GLFWImage.calloc(icons.length);
        ByteBuffer[] nativeBuffers = new ByteBuffer[icons.length];
        for (int icon = 0; icon < icons.length; ++icon) {
            nativeBuffers[icon] = BufferUtils.createByteBuffer(icons[icon].capacity());
            nativeBuffers[icon].put(icons[icon]);
            nativeBuffers[icon].flip();
            int dimension = (int)Math.sqrt((double)nativeBuffers[icon].limit() / 4.0);
            if (dimension * dimension * 4 != nativeBuffers[icon].limit()) {
                throw new IllegalStateException();
            }
            glfwImages.put(icon, GLFWImage.create().set(dimension, dimension, nativeBuffers[icon]));
        }
        GLFW.glfwSetWindowIcon(Display.getWindow(), glfwImages);
        glfwImages.free();
        return 0;
    }

    public static void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        System.out.println("TODO: Implement Display.setDisplayModeAndFullscreen(DisplayMode)");
    }

    public static void setFullscreen(boolean fullscreen) {
        long window = Display.getWindow();
        if (window == 0L) {
            startFullscreen = fullscreen;
            return;
        }
        boolean currentState = Display.isFullscreen();
        if (currentState == fullscreen) {
            return;
        }
        if (fullscreen) {
            GLFW.glfwGetWindowPos(window, savedX, savedY);
            GLFW.glfwGetWindowSize(window, savedW, savedH);
            long monitorId = GLFW.glfwGetPrimaryMonitor();
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode(monitorId);
            GLFW.glfwSetWindowMonitor(window, monitorId, 0, 0, vidMode.width(), vidMode.height(), vidMode.refreshRate());
        } else {
            GLFW.glfwSetWindowMonitor(window, 0L, savedX[0], savedY[0], savedW[0], savedH[0], 0);
        }
    }

    public static boolean isFullscreen() {
        if (Display.getWindow() != 0L) {
            return GLFW.glfwGetWindowMonitor(Display.getWindow()) != 0L;
        }
        return false;
    }

    public static void setParent(Canvas parent) {
    }

    public static void releaseContext() {
        GLFW.glfwMakeContextCurrent(0L);
    }

    public static boolean isCurrent() {
        return true;
    }

    public static void makeCurrent() {
        GLFW.glfwMakeContextCurrent(Window.handle);
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString(7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString(7938);
        }
        return "Unknown";
    }

    public static String getTitle() {
        return windowTitle;
    }

    public static Canvas getParent() {
        return null;
    }

    public static float getPixelScaleFactor() {
        if (!Display.isCreated()) {
            return 1.0f;
        }
        float[] xScale = new float[1];
        float[] yScale = new float[1];
        GLFW.glfwGetWindowContentScale(Display.getWindow(), xScale, yScale);
        return Math.max(xScale[0], yScale[0]);
    }

    public static void setSwapInterval(int value) {
        GLFW.glfwSwapInterval(value);
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) {
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    public static long getHandle() {
        return Window.handle;
    }

    static {
        Sys.initialize();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        savedX = new int[1];
        savedY = new int[1];
        savedW = new int[1];
        savedH = new int[1];
        drawable = null;
    }

    private static class Window {
        static long handle;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Window() {
        }

        public static void setCallbacks() {
            GLFW.glfwSetKeyCallback(handle, keyCallback);
            GLFW.glfwSetCharCallback(handle, charCallback);
            GLFW.glfwSetCursorPosCallback(handle, cursorPosCallback);
            GLFW.glfwSetMouseButtonCallback(handle, mouseButtonCallback);
            GLFW.glfwSetScrollCallback(handle, scrollCallback);
            GLFW.glfwSetWindowFocusCallback(handle, windowFocusCallback);
            GLFW.glfwSetWindowIconifyCallback(handle, windowIconifyCallback);
            GLFW.glfwSetWindowSizeCallback(handle, windowSizeCallback);
            GLFW.glfwSetWindowPosCallback(handle, windowPosCallback);
            GLFW.glfwSetWindowRefreshCallback(handle, windowRefreshCallback);
            GLFW.glfwSetFramebufferSizeCallback(handle, framebufferSizeCallback);
        }

        public static void releaseCallbacks() {
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }
}

