/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.extra.client.gui.options.control;

import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_837;
import org.apache.commons.lang3.Validate;

public class SliderControlExtended
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;
    private final boolean displayIntValueWhileSliding;

    public SliderControlExtended(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode, boolean displayIntValueWhileSliding) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
        this.displayIntValueWhileSliding = displayIntValueWhileSliding;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Slider(this.option, dim, this.min, this.max, this.interval, this.mode, this.displayIntValueWhileSliding);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }

    private static class Slider
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final ControlValueFormatter formatter;
        private final boolean displayIntValueWhileSliding;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public Slider(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter, boolean displayIntValueWhileSliding) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.displayIntValueWhileSliding = displayIntValueWhileSliding;
        }

        public Dim2i getSliderBounds() {
            return new Dim2i(this.dim.getLimitX() - 96, this.dim.getCenterY() - 5, 90, 10);
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider();
            } else {
                this.renderStandaloneValue();
            }
        }

        private void renderStandaloneValue() {
            int sliderX = this.getSliderBounds().x();
            int sliderY = this.getSliderBounds().y();
            int sliderWidth = this.getSliderBounds().width();
            int sliderHeight = this.getSliderBounds().height();
            class_1982 label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.method_954(label.method_7472());
            this.drawString(label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider() {
            int sliderX = this.getSliderBounds().x();
            int sliderY = this.getSliderBounds().y();
            int sliderWidth = this.getSliderBounds().width();
            int sliderHeight = this.getSliderBounds().height();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = class_837.method_8339((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            double thumbX = (double)sliderX + thumbOffset - 2.0;
            double trackY = (double)(sliderY + sliderHeight / 2) - 0.5;
            this.drawRect((int)thumbX, sliderY, (int)(thumbX + 4.0), sliderY + sliderHeight, -1);
            this.drawRect(sliderX, (int)trackY, sliderX + sliderWidth, (int)(trackY + 1.0), -1);
            class_1989 label = this.displayIntValueWhileSliding ? new class_1989(String.valueOf(this.getIntValue())) : this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.method_954(label.method_7472());
            this.drawString((class_1982)label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.getSliderBounds().containsCursor(mouseX, mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.getSliderBounds().x()) / (double)this.getSliderBounds().width());
        }

        private void setValue(double d) {
            this.thumbPosition = class_837.method_8339((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }
}

