/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.functions;

import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferStorageFlags;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferTarget;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gl.util.EnumBitField;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL44;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BufferStorageFunctions {
    NONE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CORE{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            GL44.glBufferStorage(target.getTargetParameter(), length, flags.getBitField());
        }
    }
    ,
    ARB{

        @Override
        public void createBufferStorage(GlBufferTarget target, long length, EnumBitField<GlBufferStorageFlags> flags) {
            ARBBufferStorage.glBufferStorage(target.getTargetParameter(), length, flags.getBitField());
        }
    };


    public static BufferStorageFunctions pickBest(RenderDevice device) {
        ContextCapabilities capabilities = device.getCapabilities();
        if (capabilities.OpenGL44) {
            return CORE;
        }
        if (capabilities.GL_ARB_buffer_storage) {
            return ARB;
        }
        return NONE;
    }

    public abstract void createBufferStorage(GlBufferTarget var1, long var2, EnumBitField<GlBufferStorageFlags> var4);
}

