/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.quad.properties;

import dev.vexor.radium.compat.mojang.math.Mth;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_1167;
import net.minecraft.class_1354;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum ModelQuadFacing {
    POS_X,
    POS_Y,
    POS_Z,
    NEG_X,
    NEG_Y,
    NEG_Z,
    UNASSIGNED;

    public static final ModelQuadFacing[] VALUES;
    public static final int COUNT;
    public static final int DIRECTIONS;
    public static final int UNASSIGNED_ORDINAL;
    public static final int NONE = 0;
    public static final int ALL;
    public static final Vector3fc[] ALIGNED_NORMALS;
    public static final int[] PACKED_ALIGNED_NORMALS;
    public static final int OPPOSING_X;
    public static final int OPPOSING_Y;
    public static final int OPPOSING_Z;
    public static final int UNASSIGNED_MASK;

    public static ModelQuadFacing fromDirection(class_1354 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_1354.field_5200 -> NEG_Y;
            case class_1354.field_5201 -> POS_Y;
            case class_1354.field_5202 -> NEG_Z;
            case class_1354.field_5203 -> POS_Z;
            case class_1354.field_5205 -> NEG_X;
            case class_1354.field_5204 -> POS_X;
        };
    }

    public ModelQuadFacing getOpposite() {
        return switch (this) {
            case POS_Y -> NEG_Y;
            case NEG_Y -> POS_Y;
            case POS_X -> NEG_X;
            case NEG_X -> POS_X;
            case POS_Z -> NEG_Z;
            case NEG_Z -> POS_Z;
            default -> UNASSIGNED;
        };
    }

    public int getSign() {
        return switch (this) {
            case POS_Y, POS_X, POS_Z -> 1;
            case NEG_Y, NEG_X, NEG_Z -> -1;
            default -> 0;
        };
    }

    public int getAxis() {
        return switch (this) {
            case POS_X, NEG_X -> 0;
            case POS_Y, NEG_Y -> 1;
            case POS_Z, NEG_Z -> 2;
            default -> -1;
        };
    }

    public boolean isAligned() {
        return this != UNASSIGNED;
    }

    public Vector3fc getAlignedNormal() {
        if (!this.isAligned()) {
            throw new IllegalStateException("Cannot get aligned normal for unassigned facing");
        }
        return ALIGNED_NORMALS[this.ordinal()];
    }

    public int getPackedAlignedNormal() {
        if (!this.isAligned()) {
            throw new IllegalStateException("Cannot get packed aligned normal for unassigned facing");
        }
        return PACKED_ALIGNED_NORMALS[this.ordinal()];
    }

    public static ModelQuadFacing fromNormal(Vector3fc normal) {
        for (class_1354 face : DirectionUtil.ALL_DIRECTIONS) {
            class_1167 step = face.method_10539();
            if (!Mth.equal(normal.x(), step.method_10572()) || !Mth.equal(normal.y(), step.method_10573()) || !Mth.equal(normal.z(), step.method_10574())) continue;
            return ModelQuadFacing.fromDirection(face);
        }
        return UNASSIGNED;
    }

    public static ModelQuadFacing fromNormal(float x, float y, float z) {
        for (class_1354 face : DirectionUtil.ALL_DIRECTIONS) {
            class_1167 step = face.method_10539();
            if (!Mth.equal(x, step.method_10572()) || !Mth.equal(y, step.method_10573()) || !Mth.equal(z, step.method_10574())) continue;
            return ModelQuadFacing.fromDirection(face);
        }
        return UNASSIGNED;
    }

    public static ModelQuadFacing fromPackedNormal(int normal) {
        return ModelQuadFacing.fromNormal(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal));
    }

    public static boolean bitmapIsOpposingAligned(int bitmap) {
        return bitmap == OPPOSING_X || bitmap == OPPOSING_Y || bitmap == OPPOSING_Z;
    }

    public static boolean bitmapHasUnassigned(int bitmap) {
        return (bitmap & UNASSIGNED_MASK) != 0;
    }

    static {
        VALUES = ModelQuadFacing.values();
        COUNT = VALUES.length;
        DIRECTIONS = VALUES.length - 1;
        UNASSIGNED_ORDINAL = UNASSIGNED.ordinal();
        ALL = (1 << COUNT) - 1;
        ALIGNED_NORMALS = new Vector3fc[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
        PACKED_ALIGNED_NORMALS = Arrays.stream(ALIGNED_NORMALS).mapToInt(NormI8::pack).toArray();
        OPPOSING_X = 1 << POS_X.ordinal() | 1 << NEG_X.ordinal();
        OPPOSING_Y = 1 << POS_Y.ordinal() | 1 << NEG_Y.ordinal();
        OPPOSING_Z = 1 << POS_Z.ordinal() | 1 << NEG_Z.ordinal();
        UNASSIGNED_MASK = 1 << UNASSIGNED.ordinal();
    }
}

