/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline;

import java.util.Arrays;
import java.util.List;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.ColorProviderRegistry;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_1354;
import net.minecraft.class_1600;
import net.minecraft.class_1639;
import net.minecraft.class_197;
import net.minecraft.class_2232;
import net.minecraft.class_2437;
import net.minecraft.class_2528;
import org.lwjgl.util.vector.Vector3f;

public class BlockRenderer {
    private final ColorProviderRegistry colorProviderRegistry;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData quadLightData = new QuadLightData();
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;
    private final int[] quadColors = new int[4];
    private ChunkBuildBuffers buffers;

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_1600.method_2963();
    }

    public void prepare(ChunkBuildBuffers buffers) {
        this.buffers = buffers;
    }

    public void renderModel(BlockRenderContext ctx) {
        Material material = DefaultMaterials.forBlockState(ctx.state());
        ChunkModelBuilder meshBuilder = this.buffers.get(material);
        ColorProvider colorizer = this.colorProviderRegistry.getColorProvider(ctx.state().method_9028());
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(ctx.state(), ctx.model()));
        Vector3f offset = new Vector3f();
        class_197.class_2177 offsetType = ctx.state().method_9028().method_8634();
        if (offsetType != class_197.class_2177.field_9286) {
            int x = ctx.pos().method_10572();
            int z = ctx.pos().method_10574();
            long i = (long)x * 3129871L ^ (long)z * 116129781L;
            i = i * i * 42317861L + i * 11L;
            offset.x += ((float)(i >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f;
            offset.z += ((float)(i >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f;
            if (offsetType == class_197.class_2177.field_9288) {
                offset.y += ((float)(i >> 20 & 0xFL) / 15.0f - 1.0f) * 0.2f;
            }
        }
        for (class_1354 face : DirectionUtil.ALL_DIRECTIONS) {
            List<class_2437> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.renderQuadList(ctx, material, lighter, colorizer, offset, meshBuilder, quads, face);
        }
        List<class_2437> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, material, lighter, colorizer, offset, meshBuilder, all, null);
        }
    }

    private List<class_2437> getGeometry(BlockRenderContext ctx, class_1354 face) {
        class_2528 model = ctx.model();
        return face == null ? model.method_10371() : model.method_10372(face);
    }

    private boolean isFaceVisible(BlockRenderContext ctx, class_1354 face) {
        return this.occlusionCache.shouldDrawSide(ctx.slice(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, ColorProvider colorizer, Vector3f offset, ChunkModelBuilder builder, List<class_2437> quads, class_1354 cullFace) {
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            QuadLightData lightData = this.getVertexLight(ctx, lighter, cullFace, quad);
            int[] vertexColors = this.getVertexColors(ctx, colorizer, quad);
            this.writeGeometry(ctx, builder, offset, material, quad, vertexColors, lightData);
            class_1639 sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private QuadLightData getVertexLight(BlockRenderContext ctx, LightPipeline lighter, class_1354 cullFace, BakedQuadView quad) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, ctx.pos(), light, cullFace, quad.getLightFace(), quad.hasShade(), true);
        return light;
    }

    private int[] getVertexColors(BlockRenderContext ctx, ColorProvider colorProvider, BakedQuadView quad) {
        int[] vertexColors = this.quadColors;
        if (colorProvider != null && quad.method_9980()) {
            colorProvider.getColors(ctx.slice(), ctx.state(), quad, vertexColors, ctx.pos());
        } else {
            Arrays.fill(vertexColors, 0xFFFFFF);
        }
        return vertexColors;
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, Vector3f offset, Material material, BakedQuadView quad, int[] colors, QuadLightData light) {
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(light.br, light.lm);
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + offset.x;
            out.y = ctx.origin().y() + quad.getY(srcIndex) + offset.y;
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + offset.z;
            out.color = ColorARGB.toABGR(colors[srcIndex]) | 0xFF000000;
            out.ao = light.br[srcIndex];
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = light.lm[srcIndex];
        }
        if (material.isTranslucent() && ctx.collector != null && ctx.collector.appendQuad(vertices, normalFace, quad.getFaceNormal())) {
            return;
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(class_2232 state, class_2528 model) {
        if (this.useAmbientOcclusion && model.method_10373() && state.method_9028().method_6454() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

