/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.data;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.VisibilityEncoding;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.minecraft.class_1354;
import net.minecraft.class_1639;
import net.minecraft.class_226;
import net.minecraft.class_2485;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltSectionInfo {
    public static final BuiltSectionInfo EMPTY = BuiltSectionInfo.createEmptyData();
    public final int flags;
    public final long visibilityData;
    public final class_226 @Nullable [] globalBlockEntities;
    public final class_226 @Nullable [] culledBlockEntities;
    public final class_1639 @Nullable [] animatedSprites;

    private BuiltSectionInfo(@NotNull Collection<TerrainRenderPass> blockRenderPasses, @NotNull Collection<class_226> globalBlockEntities, @NotNull Collection<class_226> culledBlockEntities, @NotNull Collection<class_1639> animatedSprites, @NotNull class_2485 occlusionData) {
        this.globalBlockEntities = BuiltSectionInfo.toArray(globalBlockEntities, class_226[]::new);
        this.culledBlockEntities = BuiltSectionInfo.toArray(culledBlockEntities, class_226[]::new);
        this.animatedSprites = BuiltSectionInfo.toArray(animatedSprites, class_1639[]::new);
        int flags = 0;
        if (!blockRenderPasses.isEmpty()) {
            flags |= 1;
        }
        if (!culledBlockEntities.isEmpty()) {
            flags |= 2;
        }
        if (!animatedSprites.isEmpty()) {
            flags |= 4;
        }
        this.flags = flags;
        this.visibilityData = VisibilityEncoding.encode(occlusionData);
    }

    private static BuiltSectionInfo createEmptyData() {
        class_2485 occlusionData = new class_2485();
        occlusionData.method_10186(EnumSet.allOf(class_1354.class));
        Builder meshInfo = new Builder();
        meshInfo.setOcclusionData(occlusionData);
        return meshInfo.build();
    }

    private static <T> T[] toArray(Collection<T> collection, IntFunction<T[]> allocator) {
        if (collection.isEmpty()) {
            return null;
        }
        return collection.toArray(allocator);
    }

    public static class Builder {
        private final List<TerrainRenderPass> blockRenderPasses = new ArrayList<TerrainRenderPass>();
        private final List<class_226> globalBlockEntities = new ArrayList<class_226>();
        private final List<class_226> culledBlockEntities = new ArrayList<class_226>();
        private final Set<class_1639> animatedSprites = new ObjectOpenHashSet<class_1639>();
        private class_2485 occlusionData;

        public void addRenderPass(TerrainRenderPass pass) {
            this.blockRenderPasses.add(pass);
        }

        public void setOcclusionData(class_2485 data) {
            this.occlusionData = data;
        }

        public void addSprite(class_1639 sprite) {
            if (sprite.method_5844()) {
                this.animatedSprites.add(sprite);
            }
        }

        public void addBlockEntity(class_226 entity, boolean cull) {
            (cull ? this.culledBlockEntities : this.globalBlockEntities).add(entity);
        }

        public BuiltSectionInfo build() {
            return new BuiltSectionInfo(this.blockRenderPasses, this.globalBlockEntities, this.culledBlockEntities, this.animatedSprites, this.occlusionData);
        }
    }
}

