/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortItemsProvider;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;

public interface RenderListProvider
extends SortItemsProvider {
    public ObjectArrayList<ChunkRenderList> getUnsortedRenderLists();

    public Map<TaskQueueType, ArrayDeque<RenderSection>> getTaskLists();

    public boolean orderIsSorted();

    public boolean needsRevisitForPendingUpdates();

    default public SortedRenderLists createRenderLists(Viewport viewport) {
        SectionPos sectionPos = viewport.getChunkCoord();
        ObjectArrayList<ChunkRenderList> unsorted = this.getUnsortedRenderLists();
        int cameraX = sectionPos.method_10572() >> RenderRegion.REGION_WIDTH_SH;
        int cameraY = sectionPos.method_10573() >> RenderRegion.REGION_HEIGHT_SH;
        int cameraZ = sectionPos.method_10574() >> RenderRegion.REGION_LENGTH_SH;
        int size = unsorted.size();
        int[] sortItems = this.ensureSortItemsOfLength(size);
        for (int i = 0; i < size; ++i) {
            RenderRegion region = unsorted.get(i).getRegion();
            int x = Math.abs(region.getX() - cameraX);
            int y = Math.abs(region.getY() - cameraY);
            int z = Math.abs(region.getZ() - cameraZ);
            sortItems[i] = x + y + z << 16 | i;
        }
        IntArrays.unstableSort(sortItems, 0, size);
        ObjectArrayList<ChunkRenderList> sorted = new ObjectArrayList<ChunkRenderList>(size);
        for (int i = 0; i < size; ++i) {
            int key = sortItems[i];
            ChunkRenderList renderList = unsorted.get(key & 0xFFFF);
            sorted.add(renderList);
        }
        for (ChunkRenderList list : sorted) {
            list.prepareForRender(sectionPos, this);
        }
        return new SortedRenderLists(sorted);
    }
}

