/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import dev.vexor.radium.frapi.api.renderer.v1.material.ShadeMode;
import dev.vexor.radium.frapi.api.renderer.v1.mesh.QuadEmitter;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.class_1158;
import net.minecraft.class_1354;
import net.minecraft.class_1600;
import net.minecraft.class_2165;
import net.minecraft.class_2232;
import net.minecraft.class_2552;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    private final BlockEmitter editorQuad = new BlockEmitter();
    protected class_1158 level;
    protected LevelSlice slice;
    protected class_2232 state;
    protected class_2552 pos;
    protected class_2165 type;
    private final BlockOcclusionCache occlusionCache = new BlockOcclusionCache();
    private boolean enableCulling = true;
    private int cullCompletionFlags;
    private int cullResultFlags;
    protected LightPipelineProvider lighters;
    protected final QuadLightData quadLightData = new QuadLightData();
    protected boolean useAmbientOcclusion;
    protected LightMode defaultLightMode;

    @Override
    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public boolean isFaceCulled(@Nullable class_1354 face) {
        if (face == null || !this.enableCulling) {
            return false;
        }
        int mask = 1 << face.method_10524();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (this.occlusionCache.shouldDrawSide(this.level, this.pos, face)) {
                this.cullResultFlags |= mask;
                return false;
            }
            return true;
        }
        return (this.cullResultFlags & mask) == 0;
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (this.isFaceCulled(quad.cullFace())) {
            return;
        }
        this.processQuad(quad);
    }

    protected abstract void processQuad(MutableQuadViewImpl var1);

    protected void prepareCulling(boolean enableCulling) {
        this.enableCulling = enableCulling;
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    protected void prepareAoInfo(boolean modelAo) {
        this.useAmbientOcclusion = class_1600.method_2963();
        int emission = this.state.method_9028().method_6454();
        this.defaultLightMode = this.useAmbientOcclusion && modelAo && emission == 0 ? LightMode.SMOOTH : LightMode.FLAT;
    }

    protected void shadeQuad(MutableQuadViewImpl quad, LightMode lightMode, boolean emissive, ShadeMode shadeMode) {
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        lighter.calculate(quad, this.pos, this.quadLightData, quad.cullFace(), quad.lightFace(), quad.hasShade(), shadeMode == ShadeMode.ENHANCED);
    }

    public class BlockEmitter
    extends MutableQuadViewImpl {
        public BlockEmitter() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            if (AbstractBlockRenderContext.this.type == null) {
                throw new IllegalStateException("No render type is set but an FRAPI object was asked to render!");
            }
            AbstractBlockRenderContext.this.renderQuad(this);
        }
    }
}

