/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.viewport;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.frustum.Frustum;
import net.minecraft.class_236;
import net.minecraft.class_2552;
import net.minecraft.class_837;

public final class Viewport {
    private final Frustum frustum;
    private final CameraTransform transform;
    private final SectionPos sectionCoords;
    private final class_2552 blockCoords;

    public Viewport(Frustum frustum, class_236 position) {
        this.frustum = frustum;
        this.transform = new CameraTransform(position.field_605, position.field_606, position.field_607);
        this.sectionCoords = SectionPos.of(SectionPos.posToSectionCoord(position.field_605), SectionPos.posToSectionCoord(position.field_606), SectionPos.posToSectionCoord(position.field_607));
        this.blockCoords = new class_2552(class_837.method_2345((double)position.field_605), class_837.method_2345((double)position.field_606), class_837.method_2345((double)position.field_607));
    }

    public boolean isBoxVisible(int intOriginX, int intOriginY, int intOriginZ, float floatSizeX, float floatSizeY, float floatSizeZ) {
        float floatOriginX = (float)intOriginX - this.transform.fracX;
        float floatOriginY = (float)intOriginY - this.transform.fracY;
        float floatOriginZ = (float)intOriginZ - this.transform.fracZ;
        return this.frustum.testAab(floatOriginX - floatSizeX, floatOriginY - floatSizeY, floatOriginZ - floatSizeZ, floatOriginX + floatSizeX, floatOriginY + floatSizeY, floatOriginZ + floatSizeZ);
    }

    public boolean isBoxVisibleDirect(float floatOriginX, float floatOriginY, float floatOriginZ, float floatSize) {
        return this.frustum.testAab(floatOriginX - floatSize, floatOriginY - floatSize, floatOriginZ - floatSize, floatOriginX + floatSize, floatOriginY + floatSize, floatOriginZ + floatSize);
    }

    public int getBoxIntersectionDirect(float floatOriginX, float floatOriginY, float floatOriginZ, float floatSize) {
        return this.frustum.intersectAab(floatOriginX - floatSize, floatOriginY - floatSize, floatOriginZ - floatSize, floatOriginX + floatSize, floatOriginY + floatSize, floatOriginZ + floatSize);
    }

    public CameraTransform getTransform() {
        return this.transform;
    }

    public SectionPos getChunkCoord() {
        return this.sectionCoords;
    }

    public class_2552 getBlockCoord() {
        return this.blockCoords;
    }
}

