/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.services;

import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.services.Services;

public interface PlatformMixinOverrides {
    public static final PlatformMixinOverrides INSTANCE = Services.load(PlatformMixinOverrides.class);

    public static PlatformMixinOverrides getInstance() {
        return INSTANCE;
    }

    public List<MixinOverride> applyModOverrides();

    public static final class MixinOverride {
        private final String modId;
        private final String option;
        private final boolean enabled;

        public MixinOverride(String modId, String option, boolean enabled) {
            this.modId = modId;
            this.option = option;
            this.enabled = enabled;
        }

        public String modId() {
            return this.modId;
        }

        public String option() {
            return this.option;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MixinOverride that = (MixinOverride)o;
            return this.enabled == that.enabled && this.modId.equals(that.modId) && this.option.equals(that.option);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.option, this.enabled);
        }

        public String toString() {
            return "MixinOverride[modId='" + this.modId + "', option='" + this.option + "', enabled=" + this.enabled + "]";
        }
    }
}

