/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.biome;

import dev.vexor.radium.compat.mojang.math.Mth;
import dev.vexor.radium.compat.mojang.minecraft.math.QuartPos;
import dev.vexor.radium.compat.mojang.minecraft.random.LinearCongruentialGenerator;
import net.caffeinemc.mods.sodium.client.world.BiomeSeedProvider;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1150;
import net.minecraft.class_1170;
import net.minecraft.class_478;

public class LevelBiomeSlice {
    private static final int SIZE = 12;
    private final class_1170[] biomes = new class_1170[1728];
    private final boolean[] uniform = new boolean[1728];
    private final BiasMap bias = new BiasMap();
    private long biomeZoomSeed;
    private int blockX;
    private int blockY;
    private int blockZ;

    public void update(class_478 level, ChunkRenderContext context) {
        this.blockX = context.origin().minBlockX() - 16;
        this.blockY = context.origin().minBlockY() - 16;
        this.blockZ = context.origin().minBlockZ() - 16;
        this.biomeZoomSeed = BiomeSeedProvider.getBiomeZoomSeed(level);
        this.copyBiomeData((class_1150)level, context);
        this.calculateBias();
        this.calculateUniform();
    }

    private void copyBiomeData(class_1150 level, ChunkRenderContext context) {
        for (int sectionX = 0; sectionX < 3; ++sectionX) {
            for (int sectionY = 0; sectionY < 3; ++sectionY) {
                for (int sectionZ = 0; sectionZ < 3; ++sectionZ) {
                    this.copySectionBiomeData(context, sectionX, sectionY, sectionZ, class_1170.field_4638);
                }
            }
        }
    }

    private void copySectionBiomeData(ChunkRenderContext context, int sectionX, int sectionY, int sectionZ, class_1170 defaultBiome) {
        ClonedChunkSection section = context.sections()[LevelSlice.getLocalSectionIndex(sectionX, sectionY, sectionZ)];
        class_1170[] biomeData = section.getBiomeData();
        for (int relCellX = 0; relCellX < 4; ++relCellX) {
            for (int relCellY = 0; relCellY < 4; ++relCellY) {
                for (int relCellZ = 0; relCellZ < 4; ++relCellZ) {
                    int cellX = sectionX * 4 + relCellX;
                    int cellY = sectionY * 4 + relCellY;
                    int cellZ = sectionZ * 4 + relCellZ;
                    int biomeX = cellX & 0xF;
                    int biomeZ = cellZ & 0xF;
                    int biomeIndex = biomeZ << 4 | biomeX;
                    int idx = LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ);
                    this.biomes[idx] = biomeData == null ? defaultBiome : biomeData[biomeIndex];
                }
            }
        }
    }

    private void calculateUniform() {
        for (int cellX = 2; cellX < 10; ++cellX) {
            for (int cellY = 2; cellY < 10; ++cellY) {
                for (int cellZ = 2; cellZ < 10; ++cellZ) {
                    this.uniform[LevelBiomeSlice.dataArrayIndex((int)cellX, (int)cellY, (int)cellZ)] = this.hasUniformNeighbors(cellX, cellY, cellZ);
                }
            }
        }
    }

    private void calculateBias() {
        int originX = this.blockX >> 2;
        int originY = this.blockY >> 2;
        int originZ = this.blockZ >> 2;
        long seed = this.biomeZoomSeed;
        for (int relCellX = 1; relCellX < 11; ++relCellX) {
            int cellX = originX + relCellX;
            long seedX = LinearCongruentialGenerator.next(seed, cellX);
            for (int relCellY = 1; relCellY < 11; ++relCellY) {
                int cellY = originY + relCellY;
                long seedXY = LinearCongruentialGenerator.next(seedX, cellY);
                for (int relCellZ = 1; relCellZ < 11; ++relCellZ) {
                    int cellZ = originZ + relCellZ;
                    long seedXYZ = LinearCongruentialGenerator.next(seedXY, cellZ);
                    this.calculateBias(LevelBiomeSlice.dataArrayIndex(relCellX, relCellY, relCellZ), cellX, cellY, cellZ, seedXYZ);
                }
            }
        }
    }

    private void calculateBias(int cellIndex, int cellX, int cellY, int cellZ, long seed) {
        seed = LinearCongruentialGenerator.next(seed, cellX);
        seed = LinearCongruentialGenerator.next(seed, cellY);
        seed = LinearCongruentialGenerator.next(seed, cellZ);
        int gradX = LevelBiomeSlice.getBias(seed);
        seed = LinearCongruentialGenerator.next(seed, this.biomeZoomSeed);
        int gradY = LevelBiomeSlice.getBias(seed);
        seed = LinearCongruentialGenerator.next(seed, this.biomeZoomSeed);
        int gradZ = LevelBiomeSlice.getBias(seed);
        this.bias.set(cellIndex, gradX, gradY, gradZ);
    }

    private boolean hasUniformNeighbors(int cellX, int cellY, int cellZ) {
        class_1170 biome = this.biomes[LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ)];
        int cellMinX = cellX - 1;
        int cellMaxX = cellX + 1;
        int cellMinY = cellY - 1;
        int cellMaxY = cellY + 1;
        int cellMinZ = cellZ - 1;
        int cellMaxZ = cellZ + 1;
        for (int adjCellX = cellMinX; adjCellX <= cellMaxX; ++adjCellX) {
            for (int adjCellY = cellMinY; adjCellY <= cellMaxY; ++adjCellY) {
                for (int adjCellZ = cellMinZ; adjCellZ <= cellMaxZ; ++adjCellZ) {
                    if (this.biomes[LevelBiomeSlice.dataArrayIndex(adjCellX, adjCellY, adjCellZ)] == biome) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public class_1170 getBiome(int blockX, int blockY, int blockZ) {
        int relBlockX = blockX - this.blockX;
        int relBlockY = blockY - this.blockY;
        int relBlockZ = blockZ - this.blockZ;
        int centerIndex = LevelBiomeSlice.dataArrayIndex(QuartPos.fromBlock(relBlockX - 2), QuartPos.fromBlock(relBlockY - 2), QuartPos.fromBlock(relBlockZ - 2));
        if (this.uniform[centerIndex]) {
            return this.biomes[centerIndex];
        }
        return this.getBiomeUsingVoronoi(relBlockX, relBlockY, relBlockZ);
    }

    private class_1170 getBiomeUsingVoronoi(int blockX, int blockY, int blockZ) {
        int x = blockX - 2;
        int y = blockY - 2;
        int z = blockZ - 2;
        int originIntX = QuartPos.fromBlock(x);
        int originIntY = QuartPos.fromBlock(y);
        int originIntZ = QuartPos.fromBlock(z);
        float originFracX = (float)QuartPos.quartLocal(x) * 0.25f;
        float originFracY = (float)QuartPos.quartLocal(y) * 0.25f;
        float originFracZ = (float)QuartPos.quartLocal(z) * 0.25f;
        float closestDistance = Float.POSITIVE_INFINITY;
        int closestArrayIndex = 0;
        for (int index = 0; index < 8; ++index) {
            float distanceZ;
            float distanceY;
            boolean dirX = (index & 4) != 0;
            boolean dirY = (index & 2) != 0;
            boolean dirZ = (index & 1) != 0;
            int cellIntX = originIntX + (dirX ? 1 : 0);
            int cellIntY = originIntY + (dirY ? 1 : 0);
            int cellIntZ = originIntZ + (dirZ ? 1 : 0);
            float cellFracX = originFracX - (dirX ? 1.0f : 0.0f);
            float cellFracY = originFracY - (dirY ? 1.0f : 0.0f);
            float cellFracZ = originFracZ - (dirZ ? 1.0f : 0.0f);
            int biasIndex = LevelBiomeSlice.dataArrayIndex(cellIntX, cellIntY, cellIntZ);
            float biasX = LevelBiomeSlice.biasToVector(this.bias.getX(biasIndex));
            float biasY = LevelBiomeSlice.biasToVector(this.bias.getY(biasIndex));
            float biasZ = LevelBiomeSlice.biasToVector(this.bias.getZ(biasIndex));
            float distanceX = Mth.square(cellFracX + biasX);
            float distance = distanceX + (distanceY = Mth.square(cellFracY + biasY)) + (distanceZ = Mth.square(cellFracZ + biasZ));
            if (!(closestDistance > distance)) continue;
            closestArrayIndex = biasIndex;
            closestDistance = distance;
        }
        return this.biomes[closestArrayIndex];
    }

    private static int dataArrayIndex(int cellX, int cellY, int cellZ) {
        return cellX * 12 * 12 + cellY * 12 + cellZ;
    }

    private static float biasToVector(int bias) {
        return (float)bias * 9.765625E-4f * 0.9f;
    }

    private static int getBias(long l) {
        return (int)((l >> 24 & 0x3FFL) - 512L);
    }

    public static class BiasMap {
        private final short[] data = new short[5184];

        public void set(int index, int x, int y, int z) {
            this.data[index * 3 + 0] = (short)x;
            this.data[index * 3 + 1] = (short)y;
            this.data[index * 3 + 2] = (short)z;
        }

        public int getX(int index) {
            return this.data[index * 3 + 0];
        }

        public int getY(int index) {
            return this.data[index * 3 + 1];
        }

        public int getZ(int index) {
            return this.data[index * 3 + 2];
        }
    }
}

