/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.core.ModRegistries;
import io.github.lightman314.lctech.common.notifications.types.EnergyTradeNotification;
import io.github.lightman314.lctech.common.notifications.types.FluidTradeNotification;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.terminal.filters.FluidTraderSearchFilter;
import io.github.lightman314.lctech.common.util.icons.FluidIcon;
import io.github.lightman314.lctech.proxy.ClientProxy;
import io.github.lightman314.lctech.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lctech")
public class LCTech {
    public static final String MODID = "lctech";
    public static final CommonProxy PROXY = FMLLoader.getDist() == Dist.CLIENT ? new ClientProxy() : new CommonProxy();
    public static final Logger LOGGER = LogManager.getLogger();

    public LCTech(@Nonnull IEventBus bus) {
        bus.addListener(this::doCommonStuff);
        bus.addListener(this::doClientStuff);
        TechConfig.init();
        ModRegistries.register(bus);
        PROXY.init(bus);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork() {
        TraderAPI.API.RegisterSearchFilter((ITraderSearchFilter)new FluidTraderSearchFilter());
        TraderAPI.API.RegisterTrader(FluidTraderData.TYPE);
        TraderAPI.API.RegisterTrader(EnergyTraderData.TYPE);
        NotificationAPI.registerNotification(FluidTradeNotification.TYPE);
        NotificationAPI.registerNotification(EnergyTradeNotification.TYPE);
        Upgrades.TRADE_OFFERS.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_FLUID.get(new Object[0]));
        Upgrades.VOID.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_FLUID.get(new Object[0]));
        Upgrades.VOID.addTarget((Component)TechText.TOOLTIP_UPGRADE_TARGET_TRADER_ENERGY.get(new Object[0]));
        FluidIcon.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", PROXY::setupClient);
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LOGGER.error(errorMessage, t);
            }
        });
    }
}

