/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.IntOption;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class TechConfig {
    public static final Common COMMON = new Common();
    public static final Server SERVER = new Server();

    public static void init() {
    }

    public static class Common
    extends ConfigFile {
        public final BooleanOption canCraftFluidTraders = BooleanOption.createTrue();
        public final BooleanOption canCraftFluidTanks = BooleanOption.createTrue();
        public final BooleanOption canCraftVoidTanks = BooleanOption.createTrue();
        public final BooleanOption canCraftEnergyTraders = BooleanOption.createTrue();
        public final BooleanOption canCraftBatteries = BooleanOption.createTrue();

        protected Common() {
            super("lctech-common");
        }

        protected void setup(@Nonnull ConfigFile.ConfigBuilder configBuilder) {
            configBuilder.comment(new Object[]{"Crafting Settings."}).push("crafting");
            configBuilder.comment(new Object[]{"Whether Fluid Traders can be crafted.", "Also affects crafting of fluid trader accessories (Fluid Trader Interface, Fluid Capacity Upgrades, etc.)", "Disabling will not remove any existing Fluid Traders from the world, nor prevent their use.", "/reload required for changes to take effect."}).add("allowFluidTraderCrafting", (ConfigOption)this.canCraftFluidTraders);
            configBuilder.comment(new Object[]{"Whether Fluid Tanks can be crafted.", "Disabling will not remove any existing fluid tanks from the world, nor prevent their use.", "/reload required for changes to take effect."}).add("allowFluidTankCrafting", (ConfigOption)this.canCraftFluidTanks);
            configBuilder.comment(new Object[]{"Wheter the Void Tank can be crafted.", "Disabling will not remove any existing fluid tanks from the world, nor prevent their use.", "/reload required for changes to take effect."}).add("allowVoidTankCrafting", (ConfigOption)this.canCraftVoidTanks);
            configBuilder.comment(new Object[]{"Whether Energy Traders can be crafted.", "Also affects crafting of energy trader accessories (Energy Trader Interface, Energy Capacity Upgrades, etc.)", "Disabling will not remove any existing Energy Traders from the world, nor prevent their use.", "/reload required for changes to take effect."}).add("allowEnergyTraderCrafting", (ConfigOption)this.canCraftEnergyTraders);
            configBuilder.comment(new Object[]{"Whether Batteries can be crafted.", "Disabling will not remove any existing Batteries from the world, nor prevent their use.", "/reload required for changes to take effect."}).add("allowBatteryCrafting", (ConfigOption)this.canCraftBatteries);
            configBuilder.pop();
        }
    }

    public static class Server
    extends SyncedConfigFile {
        public final IntOption fluidTraderDefaultStorage = IntOption.create((int)10, (int)1, (int)1000);
        public final IntOption fluidTradeMaxQuantity = IntOption.create((int)10, (int)1);
        public final IntOption ironTankCapacity = IntOption.create((int)10, (int)1, (int)5000);
        public final IntOption goldTankCapacity = IntOption.create((int)25, (int)1, (int)5000);
        public final IntOption diamondTankCapacity = IntOption.create((int)100, (int)1, (int)5000);
        public final IntOption netheriteTankCapacity = IntOption.create((int)200, (int)1, (int)5000);
        public final IntOption fluidUpgradeCapacity1 = IntOption.create((int)10, (int)1, (int)100000);
        public final IntOption fluidUpgradeCapacity2 = IntOption.create((int)25, (int)1, (int)100000);
        public final IntOption fluidUpgradeCapacity3 = IntOption.create((int)100, (int)1, (int)100000);
        public final IntOption fluidUpgradeCapacity4 = IntOption.create((int)200, (int)1, (int)100000);
        public final IntOption fluidRestockSpeed = IntOption.create((int)10000, (int)1);
        public final IntOption energyTraderDefaultStorage = IntOption.create((int)100000, (int)1000, (int)100000000);
        public final IntOption energyTradeMaxQuantity = IntOption.create((int)Integer.MAX_VALUE, (int)1);
        public final IntOption batteryCapacity = IntOption.create((int)100000, (int)1000);
        public final IntOption largeBatteryCapacity = IntOption.create((int)1000000, (int)1000);
        public final IntOption energyUpgradeCapacity1 = IntOption.create((int)100000, (int)1000, (int)100000000);
        public final IntOption energyUpgradeCapacity2 = IntOption.create((int)250000, (int)1000, (int)100000000);
        public final IntOption energyUpgradeCapacity3 = IntOption.create((int)1000000, (int)1000, (int)100000000);
        public final IntOption energyUpgradeCapacity4 = IntOption.create((int)2000000, (int)1000, (int)100000000);
        public final IntOption energyRestockSpeed = IntOption.create((int)100000, (int)1000);

        protected Server() {
            super("lctech-server", ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"server"));
        }

        protected void setup(@Nonnull ConfigFile.ConfigBuilder configBuilder) {
            configBuilder.comment(new Object[]{"Fluid Settings"}).push("fluid");
            configBuilder.comment(new Object[]{"Fluid Trader Settings"}).push("trader");
            configBuilder.comment(new Object[]{"The amount of fluid storage a fluid trade has by default in Buckets (1,000mB)."}).add("tradeStorage", (ConfigOption)this.fluidTraderDefaultStorage);
            configBuilder.comment(new Object[]{"The maximum quantity of fluids allowed to be sold or purchased in a single trade in Buckets (1,000mB).", "Regardless of the input, it will always be enforced to be less than or equal to the fluid trades current maximum capacity."}).add("tradeQuantityLimit", (ConfigOption)this.fluidTradeMaxQuantity);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Fluid Tank Settings"}).push("tank");
            configBuilder.comment(new Object[]{"The amount of fluid storage the Iron Tank can hold in Buckets (1,000mB)"}).add("ironTankCapacity", (ConfigOption)this.ironTankCapacity);
            configBuilder.comment(new Object[]{"The amount of fluid storage the Gold Tank can hold in Buckets (1,000mB)"}).add("goldTankCapacity", (ConfigOption)this.goldTankCapacity);
            configBuilder.comment(new Object[]{"The amount of fluid storage the Diamond Tank can hold in Buckets (1,000mB)"}).add("diamondTankCapacity", (ConfigOption)this.diamondTankCapacity);
            configBuilder.comment(new Object[]{"The amount of fluid storage the Netherite Tank can hold in Buckets (1,000mB)"}).add("netheriteTankCapacity", (ConfigOption)this.netheriteTankCapacity);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Fluid Upgrade Settings"}).push("upgrades");
            configBuilder.comment(new Object[]{"The amount of fluid storage added by the first Fluid Capacity upgrade (Iron) in Buckets (1,000mB)"}).add("upgradeCapacity1", (ConfigOption)this.fluidUpgradeCapacity1);
            configBuilder.comment(new Object[]{"The amount of fluid storage added by the second Fluid Capacity upgrade (Gold) in Buckets (1,000mB)"}).add("upgradeCapacity2", (ConfigOption)this.fluidUpgradeCapacity2);
            configBuilder.comment(new Object[]{"The amount of fluid storage added by the third Fluid Capacity upgrade (Diamond) in Buckets (1,000mB)"}).add("upgradeCapacity3", (ConfigOption)this.fluidUpgradeCapacity3);
            configBuilder.comment(new Object[]{"The amount of fluid storage added by the fourth Fluid Capacity upgrade (Netherite) in Buckets (1,000mB)"}).add("upgradeCapacity4", (ConfigOption)this.fluidUpgradeCapacity4);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Fluid Trader Interface Settings"}).push("interface");
            configBuilder.comment(new Object[]{"The amount of fluid in mB that can be drained or restocked in a single drain tick (once per second)."}).add("restockRate", (ConfigOption)this.fluidRestockSpeed);
            configBuilder.pop().pop();
            configBuilder.comment(new Object[]{"Energy Settings"}).push("energy");
            configBuilder.comment(new Object[]{"Energy Trader Settings"}).push("trader");
            configBuilder.comment(new Object[]{"The amount of FE an energy trader has by default."}).add("traderStorage", (ConfigOption)this.energyTraderDefaultStorage);
            configBuilder.comment(new Object[]{"The maximum amount of FE an energy trader can sell or purchase in a single trade.", "Regardless of the input, it will always be enforced to be less than or equal to the energy traders current maximum capacity"}).add("tradeQuantityLimit", (ConfigOption)this.energyTradeMaxQuantity);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Battery Settings"}).push("battery");
            configBuilder.comment(new Object[]{"The amount of FE a Battery can hold."}).add("batteryCapacity", (ConfigOption)this.batteryCapacity);
            configBuilder.comment(new Object[]{"The amount of FE a Large Battery can hold."}).add("largeBatteryCapacity", (ConfigOption)this.largeBatteryCapacity);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Energy Upgrade Settings"}).push("upgrades");
            configBuilder.comment(new Object[]{"The amount of energy storage added by the first Energy Capacity Upgrade (Iron)."}).add("upgradeCapacity1", (ConfigOption)this.energyUpgradeCapacity1);
            configBuilder.comment(new Object[]{"The amount of energy storage added by the second Energy Capacity Upgrade (Gold)."}).add("upgradeCapacity2", (ConfigOption)this.energyUpgradeCapacity2);
            configBuilder.comment(new Object[]{"The amount of energy storage added by the third Energy Capacity Upgrade (Diamond)."}).add("upgradeCapacity3", (ConfigOption)this.energyUpgradeCapacity3);
            configBuilder.comment(new Object[]{"The amount of energy storage added by the fourth Energy Capacity Upgrade (Netherite)."}).add("upgradeCapacity4", (ConfigOption)this.energyUpgradeCapacity4);
            configBuilder.pop();
            configBuilder.comment(new Object[]{"Energy Interface Settings"}).push("interface");
            configBuilder.comment(new Object[]{"The amount of FE that can be drained or restocked in a single drain tick (once per second)."}).add("restockRate", (ConfigOption)this.energyRestockSpeed);
            configBuilder.pop().pop();
        }
    }
}

