/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.energy;

import io.github.lightman314.lctech.common.blockentities.EnergyTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.blockentities.handler.EnergyInterfaceHandler;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.menu.traderinterface.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.settings.client.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EnergyStorageClientTab
extends TraderInterfaceClientTab<EnergyStorageTab> {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"textures/gui/energy_trade_extras.png");
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int FRAME_HEIGHT = 90;
    private static final int ENERGY_BAR_HEIGHT = 88;
    private static final int WIDGET_OFFSET = 43;

    public EnergyStorageClientTab(Object screen, EnergyStorageTab commonTab) {
        super(screen, (TraderInterfaceTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar(ModItems.BATTERY_LARGE));
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_STORAGE.get(new Object[0]);
    }

    private EnergyInterfaceHandler getEnergyData() {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            return be.getEnergyHandler();
        }
        return null;
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((DirectionalSettingsWidget.Builder)DirectionalSettingsWidget.builder().position(screenArea.pos.offset(screenArea.width / 2, 52))).object(this::getEnergyData).handlers(this::ToggleSide).build());
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_INTERFACE_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            gui.resetColor();
            for (Slot slot : ((EnergyStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, slot.x - 1, slot.y - 1, 206, 0, 18, 18);
            }
            gui.blit(GUI_TEXTURE, 26, 110, 46, 0, 10, 10);
            gui.blit(GUI_TEXTURE, 62, 110, 36, 0, 10, 10);
            gui.blit(GUI_TEXTURE, 13, 17, 0, 0, 18, 90);
            double fillPercent = (double)be.getStoredEnergy() / (double)be.getMaxEnergy();
            int fillHeight = MathUtil.clamp((int)((int)(88.0 * fillPercent)), (int)0, (int)88);
            int yOffset = 88 - fillHeight + 1;
            gui.blit(GUI_TEXTURE, 13, 17 + yOffset, 18, yOffset, 18, fillHeight);
            TextRenderUtil.drawCenteredText((EasyGuiGraphics)gui, (Component)LCText.GUI_SETTINGS_INPUT_SIDE.get(new Object[0]), (int)(((TraderInterfaceScreen)this.screen).getXSize() / 2), (int)43, (int)0x404040);
        }
    }

    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (this.isMouseOverEnergy(gui.mousePos)) {
                gui.renderTooltip((Component)EasyText.literal((String)(EnergyUtil.formatEnergyAmount(be.getStoredEnergy()) + "/" + EnergyUtil.formatEnergyAmount(be.getMaxEnergy()))).withStyle(ChatFormatting.AQUA));
            }
        }
    }

    private boolean isMouseOverEnergy(ScreenPosition mousePos) {
        int leftEdge = ((TraderInterfaceScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((TraderInterfaceScreen)this.screen).getGuiTop() + 17;
        return mousePos.x >= leftEdge && mousePos.x < leftEdge + 18 && mousePos.y >= topEdge && mousePos.y < topEdge + 90;
    }

    private void ToggleSide(Direction side, boolean inverse) {
        EnergyInterfaceHandler data = this.getEnergyData();
        if (data != null) {
            DirectionalSettingsState state = data.getSidedState(side);
            state = inverse ? state.getPrevious((IDirectionalSettingsObject)data) : state.getNext((IDirectionalSettingsObject)data);
            ((EnergyStorageTab)this.commonTab).toggleSide(side, state);
        }
    }
}

