/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.fluid;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.blockentities.FluidTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.blockentities.handler.FluidInterfaceHandler;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.menu.traderinterface.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.settings.client.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidStorageClientTab
extends TraderInterfaceClientTab<FluidStorageTab>
implements IScrollable,
IMouseListener {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"textures/gui/fluid_trade_extras.png");
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int TANKS = 8;
    private static final int WIDGET_OFFSET = 72;
    ScrollBarWidget scrollBar;
    int scroll = 0;

    public FluidStorageClientTab(Object screen, FluidStorageTab commonTab) {
        super(screen, (TraderInterfaceTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.IRON_TANK);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_STORAGE.get(new Object[0]);
    }

    private FluidInterfaceHandler getFluidData() {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            return be.getFluidHandler();
        }
        return null;
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        this.scrollBar = (ScrollBarWidget)this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(157, 53))).scrollable((IScrollable)this).smallKnob().build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 118)).listener((IScrollable)this).build());
        this.addChild(((DirectionalSettingsWidget.Builder)DirectionalSettingsWidget.builder().position(screenArea.pos.offset(screenArea.width / 2, 81))).object(this::getFluidData).handlers(this::ToggleSide).build());
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_INTERFACE_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            this.validateScroll();
            int index = this.scroll;
            TraderFluidStorage storage = be.getFluidBuffer();
            int yPos = 17;
            for (int x = 0; x < 8 && index < storage.getTanks(); ++index, ++x) {
                int n = 13 + x * 18;
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(index);
                gui.resetColor();
                gui.blit(GUI_TEXTURE, n, yPos, 36, 16, 18, 53);
                FluidRenderUtil.drawFluidTankInGUI(entry.filter, ((TraderInterfaceScreen)this.screen).getCorner(), n + 1, yPos + 1, 16, 51, (float)entry.getStoredAmount() / (float)storage.getTankCapacity());
                gui.resetColor();
                gui.blit(GUI_TEXTURE, n, yPos, 54, 16, 18, 53);
            }
            gui.resetColor();
            for (Slot slot : ((FluidStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, slot.x - 1, slot.y - 1, 206, 0, 18, 18);
            }
            TextRenderUtil.drawCenteredText((EasyGuiGraphics)gui, (Component)LCText.GUI_SETTINGS_INPUT_SIDE.get(new Object[0]), (int)(((TraderInterfaceScreen)this.screen).getXSize() / 2), (int)72, (int)0x404040);
        }
    }

    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            TraderFluidStorage storage = be.getFluidBuffer();
            int hoveredSlot = this.isMouseOverTank(gui.mousePos);
            if (hoveredSlot >= 0) {
                if ((hoveredSlot += this.scroll) < 0 || hoveredSlot >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(hoveredSlot);
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(FluidFormatUtil.getFluidName(entry.filter));
                tooltips.add(EasyText.literal((String)(FluidFormatUtil.formatFluidAmount(entry.getStoredAmount()) + "mB/" + FluidFormatUtil.formatFluidAmount(storage.getTankCapacity()) + "mB")).withStyle(ChatFormatting.GRAY));
                tooltips.add(TechText.TOOLTIP_FLUID_INTERACT.get(new Object[0]));
                gui.renderComponentTooltip(tooltips);
            }
        }
    }

    private int isMouseOverTank(ScreenPosition mousePos) {
        int leftEdge = ((TraderInterfaceScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((TraderInterfaceScreen)this.screen).getGuiTop() + 17;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 53) {
            return -1;
        }
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            return x;
        }
        return -1;
    }

    private int totalTankSlots() {
        if (((TraderInterfaceMenu)this.menu).getBE() instanceof FluidTraderInterfaceBlockEntity) {
            return ((FluidTraderInterfaceBlockEntity)((TraderInterfaceMenu)this.menu).getBE()).getFluidBuffer().getTanks();
        }
        return 0;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (((TraderInterfaceMenu)this.menu).getBE() instanceof FluidTraderInterfaceBlockEntity && (hoveredSlot = this.isMouseOverTank(ScreenPosition.of((double)mouseX, (double)mouseY))) >= 0) {
            ((FluidStorageTab)this.commonTab).interactWithTank(hoveredSlot += this.scroll, Screen.hasShiftDown());
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return Math.max(0, this.totalTankSlots() - 8);
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    private void ToggleSide(Direction side, boolean inverse) {
        FluidInterfaceHandler data = this.getFluidData();
        if (data != null) {
            DirectionalSettingsState state = data.getSidedState(side);
            state = inverse ? state.getPrevious((IDirectionalSettingsObject)data) : state.getNext((IDirectionalSettingsObject)data);
            ((FluidStorageTab)this.commonTab).toggleSide(side, state);
        }
    }

    @Nullable
    public Pair<FluidStack, ScreenArea> getHoveredFluid(@Nonnull ScreenPosition mousePos) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        int leftEdge = ((TraderInterfaceScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((TraderInterfaceScreen)this.screen).getGuiTop() + 17;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 53) {
            return null;
        }
        int tankIndex = -1;
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            tankIndex = x;
        }
        if (tankIndex >= 0 && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            FluidStack contents = be.getFluidBuffer().getFluidInTank(tankIndex + this.scroll);
            if (contents.isEmpty()) {
                return null;
            }
            return Pair.of((Object)contents, (Object)ScreenArea.of((int)(leftEdge + tankIndex * 18), (int)topEdge, (int)18, (int)53));
        }
        return super.getHoveredFluid(mousePos);
    }
}

