/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy;

import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyTradeEditTab;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.MutableComponent;

public class EnergyTradeEditClientTab
extends TraderStorageClientTab<EnergyTradeEditTab>
implements TradeInteractionHandler,
IMouseListener {
    TradeButton tradeDisplay;
    MoneyValueWidget priceSelection;
    EditBox quantityInput;
    EasyButton buttonToggleTradeType;
    private int selection;

    public EnergyTradeEditClientTab(Object screen, EnergyTradeEditTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((Supplier)ModItems.TRADING_CORE);
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    public boolean tabVisible() {
        return false;
    }

    public boolean blockInventoryClosing() {
        return true;
    }

    public int getTradeRuleTradeIndex() {
        return ((EnergyTradeEditTab)this.commonTab).getTradeIndex();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        EnergyTradeData trade = ((EnergyTradeEditTab)this.commonTab).getTrade();
        this.tradeDisplay = (TradeButton)this.addChild(((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(10, 18))).context(() -> ((ITraderStorageMenu)((ITraderStorageMenu)this.menu)).getContext()).trade(((EnergyTradeEditTab)this.commonTab)::getTrade).build());
        this.priceSelection = (MoneyValueWidget)this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 40))).oldIfNotFirst(firstOpen, this.priceSelection).startingValue((TradeData)trade).valueHandler(this::onValueChanged).build());
        this.quantityInput = (EditBox)this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(20, 75)).width(screenArea.width - 42 - this.getFont().width("FE")).handler(((EnergyTradeEditTab)this.commonTab)::setQuantity).apply(IntParser.builder().min(0).consumer()).startingValue((Object)(trade != null ? trade.getAmount() : 0)).build());
        this.buttonToggleTradeType = (EasyButton)this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 120))).size(72, 20)).text(() -> ((EnergyTradeEditTab)this.commonTab).getTrade().getTradeDirection().getName()).pressAction(this::ToggleTradeType)).build());
    }

    protected void closeAction() {
        this.selection = -1;
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        gui.resetColor();
        gui.blit(TraderScreen.GUI_TEXTURE, this.getArrowPosition(), 10, 214, 18, 8, 6);
        if (this.selection >= 0) {
            gui.drawShadowed("FE", ((ITraderStorageScreen)this.screen).getXSize() - 20 - gui.font.width("FE"), 78, 0xFFFFFF);
        }
    }

    private int getArrowPosition() {
        EnergyTradeData trade = this.getTrade();
        if (this.selection < 0) {
            if (trade.isSale()) {
                return 25;
            }
            return 116;
        }
        if (trade.isSale()) {
            return 99;
        }
        return 41;
    }

    private void validateRenderables() {
        this.priceSelection.visible = this.selection < 0;
        this.quantityInput.visible = this.selection >= 0;
    }

    protected void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            ((EnergyTradeEditTab)this.commonTab).setTradeIndex(message.getInt("TradeIndex"));
        }
        if (message.contains("StartingSlot")) {
            this.selection = message.getInt("StartingSlot");
        }
    }

    public void HandleTradeInputInteraction(@Nonnull TraderData traderData, @Nonnull TradeData trade, @Nonnull TradeInteractionData tradeInteractionData, int i) {
        if (trade instanceof EnergyTradeData) {
            EnergyTradeData t = (EnergyTradeData)trade;
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                this.changeSelection(0);
            }
        }
    }

    public void HandleTradeOutputInteraction(@Nonnull TraderData traderData, @Nonnull TradeData trade, @Nonnull TradeInteractionData tradeInteractionData, int i) {
        if (trade instanceof EnergyTradeData) {
            EnergyTradeData t = (EnergyTradeData)trade;
            if (t.isSale()) {
                this.changeSelection(0);
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    public void HandleOtherTradeInteraction(@Nonnull TraderData traderData, @Nonnull TradeData tradeData, @Nonnull TradeInteractionData tradeInteractionData) {
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.changeValue(((EnergyTradeEditTab)this.commonTab).getTrade().getCost());
        }
        if (this.selection >= 0) {
            this.quantityInput.setValue(String.valueOf(((EnergyTradeEditTab)this.commonTab).getTrade().getAmount()));
        }
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.HandleInteractionClick((int)mouseX, (int)mouseY, button, (TradeInteractionHandler)this);
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void onValueChanged(MoneyValue value) {
        ((EnergyTradeEditTab)this.commonTab).setPrice(value);
    }

    public EnergyTradeData getTrade() {
        return ((EnergyTradeEditTab)this.commonTab).getTrade();
    }

    private void ToggleTradeType(EasyButton button) {
        EnergyTradeData trade = this.getTrade();
        if (trade != null) {
            ((EnergyTradeEditTab)this.commonTab).setType(trade.isSale() ? TradeDirection.PURCHASE : TradeDirection.SALE);
        }
    }
}

