/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.settings.energy;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EnergyInputAddon
extends InputTabAddon {
    public static final EnergyInputAddon INSTANCE = new EnergyInputAddon();
    EasyButton buttonDrainMode;

    private EnergyInputAddon() {
    }

    public void onOpen(SettingsSubTab settingsSubTab, ScreenArea screenArea, boolean firstOpen) {
        this.buttonDrainMode = (EasyButton)settingsSubTab.addChild((Object)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 100))).width(screenArea.width - 40)).text(this.getOutputModeTextSource(settingsSubTab)).pressAction(() -> this.ToggleDrainMode(settingsSubTab))).addon(EasyAddonHelper.visibleCheck(this.drainable(settingsSubTab)))).build());
    }

    public void renderBG(@Nonnull SettingsSubTab settingsSubTab, @Nonnull EasyGuiGraphics easyGuiGraphics) {
    }

    public void renderAfterWidgets(@Nonnull SettingsSubTab settingsSubTab, @Nonnull EasyGuiGraphics easyGuiGraphics) {
    }

    private Supplier<Boolean> drainable(SettingsSubTab settingsSubTab) {
        return () -> {
            EnergyTraderData e;
            TraderData trader = settingsSubTab.menu.getTrader();
            return trader instanceof EnergyTraderData && (e = (EnergyTraderData)trader).drainCapable();
        };
    }

    public void tick(@Nonnull SettingsSubTab settingsSubTab) {
    }

    public void onClose(@Nonnull SettingsSubTab settingsSubTab) {
    }

    private Supplier<Component> getOutputModeTextSource(SettingsSubTab settingsSubTab) {
        return () -> TechText.GUI_SETTINGS_ENERGY_DRAINMODE.get(new Object[]{this.getOutputModeText(settingsSubTab)});
    }

    private MutableComponent getOutputModeText(SettingsSubTab settingsSubTab) {
        TraderData trader = settingsSubTab.menu.getTrader();
        if (trader instanceof EnergyTraderData) {
            EnergyTraderData e = (EnergyTraderData)trader;
            if (e.isAlwaysDrainMode()) {
                return TechText.GUI_SETTINGS_ENERGY_DRAINMODE_FULL.get(new Object[0]);
            }
            return TechText.GUI_SETTINGS_ENERGY_DRAINMODE_SALES.get(new Object[0]);
        }
        return EasyText.literal((String)"NULL");
    }

    private void ToggleDrainMode(SettingsSubTab settingsSubTab) {
        TraderData traderData = settingsSubTab.menu.getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData e = (EnergyTraderData)traderData;
            settingsSubTab.sendMessage(settingsSubTab.builder().setInt("NewEnergyDrainMode", e.getDrainMode().index + 1));
        }
    }
}

