/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.models.items;

import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTankFinalizedModel
implements BakedModel {
    private final BakedModel parentModel;
    private final FluidStack tank;
    private final Supplier<Integer> capacity;
    private final Supplier<FluidRenderData> renderData;

    public FluidTankFinalizedModel(BakedModel parentModel, FluidStack tank, Supplier<Integer> capacity, Supplier<FluidRenderData> renderData) {
        this.parentModel = parentModel;
        this.tank = tank;
        this.capacity = capacity;
        this.renderData = renderData;
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull RandomSource rand) {
        if (side != null) {
            return this.parentModel.getQuads(state, side, rand);
        }
        ArrayList<BakedQuad> combinedQuadsList = new ArrayList<BakedQuad>(this.parentModel.getQuads(state, side, rand));
        combinedQuadsList.addAll(FluidRenderUtil.getBakedFluidQuads(this.tank, this.capacity.get(), this.renderData.get()));
        return combinedQuadsList;
    }

    public boolean useAmbientOcclusion() {
        return this.parentModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.parentModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return this.parentModel.isCustomRenderer();
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.parentModel.getParticleIcon();
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return this.parentModel.getTransforms();
    }
}

