/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.models.items;

import io.github.lightman314.lctech.client.models.items.FluidTankFinalizedModel;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderDataManager;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.blocks.IFluidTankBlock;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTankModel
implements BakedModel {
    BakedModel baseFluidTankModel;
    ItemOverrides fluidTankItemOverrideList = new FluidTankItemOverrideList();

    public FluidTankModel(BakedModel baseFluidTankModel) {
        this.baseFluidTankModel = baseFluidTankModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand) {
        return this.baseFluidTankModel.getQuads(state, side, rand);
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return this.fluidTankItemOverrideList;
    }

    public boolean useAmbientOcclusion() {
        return this.baseFluidTankModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseFluidTankModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseFluidTankModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.baseFluidTankModel.isCustomRenderer();
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseFluidTankModel.getParticleIcon();
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return this.baseFluidTankModel.getTransforms();
    }

    public static class FluidTankItemOverrideList
    extends ItemOverrides {
        public BakedModel resolve(@Nonnull BakedModel model, @Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int light) {
            BlockItem blockItem;
            Block block;
            Supplier<FluidRenderData> renderData = () -> FluidRenderDataManager.getDataOrEmpty(FluidTankBlock.DATA_SOLO);
            FluidStack tank = FluidTankItem.GetFluid(stack);
            Item item = stack.getItem();
            if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IFluidTankBlock) {
                IFluidTankBlock tankBlock = (IFluidTankBlock)block;
                renderData = tankBlock::getItemRenderData;
            }
            return new FluidTankFinalizedModel(model, tank, () -> FluidTankItem.GetCapacity(stack), renderData);
        }
    }
}

