/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.resourcepacks.data.model_variants.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidRenderDataList {
    public static VariantProperty<FluidRenderDataList> PROPERTY = new FluidRenderDataProperty();
    private final Map<Direction, List<FluidRenderDataEntry>> values;

    @Nullable
    public FluidRenderData getSided(Direction side, int index) {
        List<FluidRenderDataEntry> list = this.values.getOrDefault(side, (List<FluidRenderDataEntry>)ImmutableList.of());
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index).get();
    }

    @Nullable
    @Deprecated
    public FluidRenderData get(int index) {
        return this.getSided(Direction.NORTH, index);
    }

    public FluidRenderDataList(FluidRenderDataEntry value) {
        this((List<FluidRenderDataEntry>)ImmutableList.of((Object)value));
    }

    public FluidRenderDataList(List<FluidRenderDataEntry> values) {
        this(FluidRenderDataList.sidelessMap(values));
    }

    public FluidRenderDataList(Map<Direction, List<FluidRenderDataEntry>> values) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)4);
        for (int i = 0; i < 4; ++i) {
            Direction side = Direction.from2DDataValue((int)i);
            builder.put((Object)side, (Object)ImmutableList.copyOf((Collection)values.getOrDefault(side, (List<FluidRenderDataEntry>)ImmutableList.of())));
        }
        this.values = builder.buildKeepingLast();
    }

    private static Map<Direction, List<FluidRenderDataEntry>> sidelessMap(List<FluidRenderDataEntry> list) {
        HashMap<Direction, List<FluidRenderDataEntry>> map = new HashMap<Direction, List<FluidRenderDataEntry>>();
        for (int i = 0; i < 4; ++i) {
            map.put(Direction.from2DDataValue((int)i), list);
        }
        return map;
    }

    JsonElement write() {
        if (this.sidesEqual()) {
            JsonArray list = new JsonArray();
            for (FluidRenderDataEntry entry : this.values.get(Direction.NORTH)) {
                list.add(entry.write());
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            return list;
        }
        JsonObject json = new JsonObject();
        for (Direction side : this.values.keySet()) {
            JsonArray list = new JsonArray();
            for (FluidRenderDataEntry entry : this.values.get(side)) {
                list.add(entry.write());
            }
            if (list.size() == 1) {
                json.add(side.toString(), list.get(0));
                continue;
            }
            json.add(side.toString(), (JsonElement)list);
        }
        return json;
    }

    private boolean sidesEqual() {
        List<FluidRenderDataEntry> firstList = this.values.getOrDefault(Direction.from2DDataValue((int)0), (List<FluidRenderDataEntry>)ImmutableList.of());
        for (int i = 1; i < 4; ++i) {
            if (this.values.getOrDefault(Direction.from2DDataValue((int)i), (List<FluidRenderDataEntry>)ImmutableList.of()).equals(firstList)) continue;
            return false;
        }
        return true;
    }

    public static interface FluidRenderDataEntry {
        public FluidRenderData get();

        public JsonElement write();

        public static FluidRenderDataEntry create(ResourceLocation renderDataID) {
            return new IDEntry(renderDataID);
        }

        public static FluidRenderDataEntry create(FluidRenderData data) {
            return new InstanceEntry(data);
        }
    }

    private static class FluidRenderDataProperty
    extends VariantProperty<FluidRenderDataList> {
        private FluidRenderDataProperty() {
        }

        public FluidRenderDataList parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            String elementName = this.getID().toString();
            if (element.isJsonObject()) {
                JsonObject object = GsonHelper.convertToJsonObject((JsonElement)element, (String)elementName);
                HashMap<Direction, List<FluidRenderDataEntry>> map = new HashMap<Direction, List<FluidRenderDataEntry>>();
                for (int i = 0; i < 4; ++i) {
                    Direction side = Direction.from2DDataValue((int)i);
                    if (!object.has(side.toString())) continue;
                    map.put(side, this.parseList(object.get(side.toString()), side.toString()));
                }
                if (!map.isEmpty()) {
                    return new FluidRenderDataList(map);
                }
            }
            return new FluidRenderDataList(this.parseList(element, elementName));
        }

        private List<FluidRenderDataEntry> parseList(JsonElement element, String name) {
            if (element.isJsonArray()) {
                JsonArray array = GsonHelper.convertToJsonArray((JsonElement)element, (String)name);
                ArrayList<FluidRenderDataEntry> list = new ArrayList<FluidRenderDataEntry>();
                for (int i = 0; i < array.size(); ++i) {
                    list.add(this.parseEntry(array.get(i), name + "[" + i + "]"));
                }
                return list;
            }
            return Lists.newArrayList((Object[])new FluidRenderDataEntry[]{this.parseEntry(element, name)});
        }

        private FluidRenderDataEntry parseEntry(JsonElement element, String name) {
            if (element.isJsonPrimitive()) {
                ResourceLocation dataID = VersionUtil.parseResource((String)GsonHelper.convertToString((JsonElement)element, (String)name));
                return new IDEntry(dataID);
            }
            return new InstanceEntry(FluidRenderData.parse(GsonHelper.convertToJsonObject((JsonElement)element, (String)name)));
        }

        public JsonElement write(Object value) {
            if (value instanceof FluidRenderDataList) {
                FluidRenderDataList data = (FluidRenderDataList)value;
                return data.write();
            }
            throw new IllegalArgumentException("Value must be a FluidRenderDataEntry element!");
        }
    }

    private record InstanceEntry(FluidRenderData data) implements FluidRenderDataEntry
    {
        @Override
        public FluidRenderData get() {
            return this.data;
        }

        @Override
        public JsonElement write() {
            return this.data.write();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InstanceEntry) {
                InstanceEntry other = (InstanceEntry)obj;
                return other.data.equals(this.data);
            }
            return false;
        }
    }

    private record IDEntry(ResourceLocation renderDataID) implements FluidRenderDataEntry
    {
        @Override
        public FluidRenderData get() {
            return FluidRenderDataManager.getDataOrEmpty(this.renderDataID);
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive(this.renderDataID.toString());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IDEntry) {
                IDEntry other = (IDEntry)obj;
                return other.renderDataID.equals((Object)this.renderDataID);
            }
            return false;
        }
    }
}

