/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.fluid_tank;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankBlockEntity;
import io.github.lightman314.lctech.network.message.fluid_tank.SMessageSyncTankStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankStackCache {
    public static final TankStackCache DUMMY = new TankStackCache(new ArrayList<FluidTankBlockEntity>());
    private final ImmutableList<FluidTankBlockEntity> tanksBottomToTop;
    private final ImmutableList<FluidTankBlockEntity> tanksTopToBottom;

    private TankStackCache(FluidTankBlockEntity tank) {
        this((List<FluidTankBlockEntity>)ImmutableList.of((Object)((Object)tank)));
    }

    private TankStackCache(List<FluidTankBlockEntity> tanks) {
        this.tanksBottomToTop = ImmutableList.copyOf(tanks);
        this.tanksTopToBottom = TankStackCache.invertList(this.tanksBottomToTop);
    }

    private static ImmutableList<FluidTankBlockEntity> invertList(ImmutableList<FluidTankBlockEntity> tanks) {
        ArrayList<FluidTankBlockEntity> result = new ArrayList<FluidTankBlockEntity>();
        for (int i = tanks.size() - 1; i >= 0; --i) {
            result.add((FluidTankBlockEntity)((Object)tanks.get(i)));
        }
        return ImmutableList.copyOf(result);
    }

    public final List<FluidTankBlockEntity> getOrderedTanks() {
        return this.isLighterThanAir() ? this.tanksTopToBottom : this.tanksBottomToTop;
    }

    public final List<FluidTankBlockEntity> getOrderedTanks(FluidStack fluid) {
        return fluid.getFluid().getFluidType().isLighterThanAir() ? this.tanksTopToBottom : this.tanksBottomToTop;
    }

    public final boolean isLighterThanAir() {
        return this.getRelevantFluid().getFluid().getFluidType().isLighterThanAir();
    }

    private FluidStack getRelevantFluid() {
        for (FluidTankBlockEntity tank : this.tanksBottomToTop) {
            FluidStack fluid = tank.getTankContents();
            if (fluid.isEmpty()) continue;
            return fluid.copy();
        }
        return FluidStack.EMPTY;
    }

    @Nullable
    public final FluidTankBlockEntity getTankAbove(FluidTankBlockEntity tank) {
        List<FluidTankBlockEntity> tanks = this.getOrderedTanks();
        int index = tanks.indexOf((Object)tank);
        if (index >= 0 && index < tanks.size() - 1) {
            return tanks.get(index + 1);
        }
        return null;
    }

    public final TankStackCache init(boolean isServer) {
        for (FluidTankBlockEntity tank : this.tanksBottomToTop) {
            tank.setTankStack(this);
        }
        if (this.tanksBottomToTop.size() <= 1) {
            return this;
        }
        FluidStack totalContents = FluidStack.EMPTY;
        for (FluidTankBlockEntity tank : this.tanksBottomToTop) {
            FluidStack tankContents = tank.getTankContents();
            if (tankContents.isEmpty()) continue;
            if (totalContents.isEmpty()) {
                totalContents = tankContents.copy();
                continue;
            }
            if (FluidStack.isSameFluidSameComponents((FluidStack)totalContents, (FluidStack)tankContents)) {
                totalContents.grow(tankContents.getAmount());
                continue;
            }
            LightmansCurrency.LogError((String)("Tank in new Tank Stack doesn't contain a matching fluid. " + tankContents.getAmount() + "mB of " + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)tankContents.getFluid())) + " will be lost to the void!"));
        }
        ((FluidTankBlockEntity)((Object)this.tanksBottomToTop.getFirst())).handler.setTankContents(totalContents);
        if (isServer) {
            this.syncToClients();
        }
        return this;
    }

    public final void refactorExcluded(TankStackCache newCache) {
        for (FluidTankBlockEntity tank : this.tanksBottomToTop) {
            if (newCache.tanksBottomToTop.contains((Object)tank)) continue;
            tank.enqueTankStackRefactor();
        }
    }

    public static TankStackCache create(Level level, BlockPos corePosition, int bottomY, int topY) {
        ArrayList<FluidTankBlockEntity> tanks = new ArrayList<FluidTankBlockEntity>();
        for (int y = bottomY; y <= topY; ++y) {
            BlockPos pos = corePosition.atY(y);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof FluidTankBlockEntity)) continue;
            FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
            tanks.add(tank);
        }
        return new TankStackCache(tanks);
    }

    public static TankStackCache solo(FluidTankBlockEntity tank) {
        return new TankStackCache(tank);
    }

    public final SMessageSyncTankStack getSyncPacket() {
        return new SMessageSyncTankStack(new PacketBuilder(this));
    }

    private void syncToClients() {
        FluidTankBlockEntity bottomTank;
        Level level;
        if (!this.tanksBottomToTop.isEmpty() && (level = (bottomTank = (FluidTankBlockEntity)((Object)this.tanksBottomToTop.getFirst())).getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.getSyncPacket().sendToPlayersTrackingChunk(level2, new ChunkPos(bottomTank.getBlockPos()));
        }
    }

    public static PacketBuilder decode(FriendlyByteBuf buffer) {
        return new PacketBuilder(buffer);
    }

    public static class PacketBuilder {
        private final BlockPos startPos;
        private final List<Integer> yPos;

        private PacketBuilder(TankStackCache parent) {
            if (parent.tanksBottomToTop.isEmpty()) {
                this.startPos = new BlockPos(0, 0, 0);
                this.yPos = new ArrayList<Integer>();
            } else {
                this.startPos = ((FluidTankBlockEntity)((Object)parent.tanksBottomToTop.getFirst())).getBlockPos();
                this.yPos = new ArrayList<Integer>(parent.tanksBottomToTop.size());
                for (FluidTankBlockEntity tank : parent.tanksBottomToTop) {
                    this.yPos.add(tank.getBlockPos().getY());
                }
            }
        }

        private PacketBuilder(FriendlyByteBuf buffer) {
            this.startPos = buffer.readBlockPos();
            this.yPos = new ArrayList<Integer>();
            int posCount = buffer.readInt();
            while (posCount-- > 0) {
                this.yPos.add(buffer.readInt());
            }
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeBlockPos(this.startPos);
            buffer.writeInt(this.yPos.size());
            for (int pos : this.yPos) {
                buffer.writeInt(pos);
            }
        }

        public TankStackCache build(Level level) {
            ArrayList<FluidTankBlockEntity> tanks = new ArrayList<FluidTankBlockEntity>();
            for (int y : this.yPos) {
                BlockEntity blockEntity = level.getBlockEntity(this.startPos.atY(y));
                if (!(blockEntity instanceof FluidTankBlockEntity)) continue;
                FluidTankBlockEntity tank = (FluidTankBlockEntity)blockEntity;
                tanks.add(tank);
            }
            return new TankStackCache(tanks);
        }
    }
}

