/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.blockentities.handler;

import io.github.lightman314.lctech.common.blockentities.EnergyTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.ConfigurableSidedHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyInterfaceHandler
extends ConfigurableSidedHandler<IEnergyStorage> {
    public static final ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"energy_interface");
    protected final EnergyTraderInterfaceBlockEntity blockEntity;
    public final IEnergyStorage tradeHandler;
    private final Map<Direction, Handler> handlers = new HashMap<Direction, Handler>();

    public EnergyInterfaceHandler(EnergyTraderInterfaceBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.tradeHandler = new Handler(this, null);
    }

    public ResourceLocation getType() {
        return TYPE;
    }

    public String getTag() {
        return "EnergyData";
    }

    public IEnergyStorage getHandler(Direction side) {
        if (side == null) {
            return null;
        }
        if (!this.handlers.containsKey(side)) {
            this.handlers.put(side, new Handler(this, side));
        }
        return this.handlers.get(side);
    }

    private static class Handler
    implements IEnergyStorage {
        final EnergyInterfaceHandler handler;
        final Direction side;

        Handler(EnergyInterfaceHandler handler, Direction side) {
            this.handler = handler;
            this.side = side;
        }

        public boolean canExtract() {
            return this.side == null || this.handler.allowOutputSide(this.side);
        }

        public boolean canReceive() {
            return this.side == null || this.handler.allowInputSide(this.side);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int receivableAmount = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceive);
            if (receivableAmount <= 0) {
                return 0;
            }
            if (!simulate) {
                this.handler.blockEntity.addStoredEnergy(receivableAmount);
            }
            return receivableAmount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int extractableAmount = Math.min(this.getEnergyStored(), maxExtract);
            if (extractableAmount <= 0) {
                return 0;
            }
            if (!simulate) {
                this.handler.blockEntity.drainStoredEnergy(extractableAmount);
            }
            return extractableAmount;
        }

        public int getEnergyStored() {
            return this.handler.blockEntity.getStoredEnergy();
        }

        public int getMaxEnergyStored() {
            return this.handler.blockEntity.getMaxEnergy();
        }
    }
}

