/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BatteryItem
extends Item
implements IBatteryItem {
    private final Supplier<Integer> maxEnergyStorage;

    @Override
    public int getMaxEnergyStorage(ItemStack stack) {
        return this.maxEnergyStorage.get();
    }

    public BatteryItem(Supplier<Integer> maxEnergyStorage, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.maxEnergyStorage = maxEnergyStorage;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)EasyText.literal((String)(EnergyUtil.formatEnergyAmount(IBatteryItem.getStoredEnergy(stack)) + "/" + EnergyUtil.formatEnergyAmount(this.getMaxEnergyStorage(stack)))).withStyle(ChatFormatting.AQUA));
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return IBatteryItem.isEnergyBarVisible(stack);
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round((float)Math.min(IBatteryItem.getStoredEnergy(stack), this.getMaxEnergyStorage(stack)) * 13.0f / (float)this.getMaxEnergyStorage(stack));
    }

    public int getBarColor(@Nonnull ItemStack stack) {
        return ChatFormatting.AQUA.getColor();
    }
}

