/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.blockentities.fluid_tank.FluidTankBlockEntity;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.core.ModDataComponents;
import io.github.lightman314.lctech.common.items.data.FluidData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidTankItem
extends BlockItem {
    private static final List<FluidTankItem> TANK_ITEMS = Lists.newArrayList();

    @OnlyIn(value=Dist.CLIENT)
    public static List<ModelResourceLocation> getTankModelList() {
        ArrayList list = Lists.newArrayList();
        TANK_ITEMS.forEach(tankItem -> list.add(new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)tankItem), "inventory")));
        return list;
    }

    public FluidTankItem(Block block, Item.Properties properties) {
        super(block, properties);
        TANK_ITEMS.add(this);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (FluidTankItem.getData((ItemStack)stack).showTooltip) {
            FluidStack fluid = FluidTankItem.GetFluid(stack);
            if (!fluid.isEmpty()) {
                tooltip.add((Component)FluidFormatUtil.getFluidName(fluid));
                int capacity = FluidTankItem.GetCapacity(stack);
                tooltip.add((Component)Component.literal((String)(FluidFormatUtil.formatFluidAmount(fluid.getAmount()) + "mB / " + FluidFormatUtil.formatFluidAmount(capacity) + "mB")).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)TechText.TOOLTIP_TANK_CAPACITY.get(new Object[]{FluidFormatUtil.formatFluidAmount(FluidTankItem.GetCapacity(stack))}));
            }
        }
    }

    @Nonnull
    private static FluidData getData(@Nonnull ItemStack stack) {
        return (FluidData)stack.getOrDefault(ModDataComponents.FLUID_DATA, (Object)FluidData.EMPTY);
    }

    public static FluidStack GetFluid(ItemStack stack) {
        if (stack.getItem() instanceof FluidTankItem) {
            return FluidTankItem.getData(stack).getFluid();
        }
        return FluidStack.EMPTY;
    }

    private FluidTankBlock getTankBlock() {
        Block block = this.getBlock();
        if (block instanceof FluidTankBlock) {
            return (FluidTankBlock)block;
        }
        return null;
    }

    public static int GetCapacity(ItemStack stack) {
        FluidTankItem tank;
        FluidTankBlock block;
        Item item = stack.getItem();
        if (item instanceof FluidTankItem && (block = (tank = (FluidTankItem)item).getTankBlock()) != null) {
            return block.getTankCapacity();
        }
        return 10000;
    }

    public static ItemStack GetItemFromTank(@Nonnull FluidTankBlockEntity blockEntity) {
        ItemStack returnStack = new ItemStack((ItemLike)blockEntity.getBlockState().getBlock().asItem());
        FluidStack tank = blockEntity.getTankContents();
        FluidTankItem.WriteTankData(returnStack, tank);
        return returnStack;
    }

    public static void WriteTankData(ItemStack stack, FluidStack tank) {
        FluidData data = FluidTankItem.getData(stack);
        stack.set(ModDataComponents.FLUID_DATA, (Object)data.withFluid(tank));
    }

    @Nullable
    public static IFluidHandlerItem createHandler(@Nonnull ItemStack stack) {
        if (stack.getItem() instanceof FluidTankItem) {
            return new FluidTankCapability(stack);
        }
        return null;
    }

    public static class FluidTankCapability
    implements IFluidHandlerItem {
        final ItemStack stack;

        private FluidStack tank() {
            return FluidTankItem.GetFluid(this.stack);
        }

        private void setTank(FluidStack tank) {
            FluidTankItem.WriteTankData(this.stack, tank);
        }

        private int capacity() {
            return FluidTankItem.GetCapacity(this.stack);
        }

        private int getTankSpace() {
            return this.capacity() - this.tank().getAmount();
        }

        public FluidTankCapability(ItemStack stack) {
            this.stack = stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.tank().copy() : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.capacity() : 10000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && (this.tank().isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tank(), (FluidStack)stack));
        }

        public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (this.isFluidValid(0, resource)) {
                int fillAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.getTankSpace());
                if (action.execute() && fillAmount > 0) {
                    if (this.tank().isEmpty()) {
                        this.setTank(resource.copyWithAmount(fillAmount));
                    } else {
                        FluidStack tank = this.tank();
                        tank.grow(fillAmount);
                        this.setTank(tank);
                    }
                }
                return fillAmount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)this.tank(), (FluidStack)resource)) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
            }
            return resultStack;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)maxDrain, (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
            }
            return resultStack;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }
    }
}

