/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.slots;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BatteryInputSlot
extends EasySlot {
    public static final ResourceLocation EMPTY_BATTERY_SLOT = ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"item/empty_battery_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_BATTERY_SLOT);
    public boolean requireEnergy = false;

    public BatteryInputSlot(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        return super.mayPlace(stack) && this.meetsRequirements(stack);
    }

    private boolean meetsRequirements(@Nonnull ItemStack stack) {
        IEnergyStorage storage = EnergyUtil.getEnergyHandler(stack).orElse(null);
        if (storage == null) {
            return false;
        }
        if (this.requireEnergy) {
            return storage.getEnergyStored() > 0;
        }
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return BACKGROUND;
    }
}

