/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.notifications.types;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxableNotification;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class EnergyTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<EnergyTradeNotification> TYPE = new NotificationType(ResourceLocation.fromNamespaceAndPath((String)"lctech", (String)"energy_trade"), EnergyTradeNotification::new);
    TraderCategory traderData;
    TradeDirection tradeType;
    int quantity;
    MoneyValue cost = MoneyValue.empty();
    String customer;

    private EnergyTradeNotification() {
    }

    protected EnergyTradeNotification(EnergyTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.quantity = trade.getAmount();
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(EnergyTradeData trade, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        return () -> new EnergyTradeNotification(trade, cost, customer, traderData, taxesPaid);
    }

    @Nonnull
    public NotificationType<EnergyTradeNotification> getType() {
        return TYPE;
    }

    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent boughtText = this.tradeType.getActionPhrase();
        return TechText.NOTIFICATION_TRADE_ENERGY.get(new Object[]{this.customer, boughtText, EnergyUtil.formatEnergyAmount(this.quantity), this.cost.getString()});
    }

    protected void saveNormal(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("TraderInfo", (Tag)this.traderData.save(lookup));
        compound.putInt("TradeType", this.tradeType.index);
        compound.putInt("Quantity", this.quantity);
        compound.put("Price", (Tag)this.cost.save());
        compound.putString("Customer", this.customer);
    }

    protected void loadNormal(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.traderData = new TraderCategory(compound.getCompound("TraderInfo"), lookup);
        this.tradeType = TradeDirection.fromIndex((int)compound.getInt("TradeType"));
        this.quantity = compound.getInt("Quantity");
        this.cost = MoneyValue.safeLoad((CompoundTag)compound, (String)"Price");
        this.customer = compound.getString("Customer");
    }

    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof EnergyTradeNotification) {
            EnergyTradeNotification etn = (EnergyTradeNotification)other;
            if (!etn.traderData.matches((NotificationCategory)this.traderData)) {
                return false;
            }
            if (etn.tradeType != this.tradeType) {
                return false;
            }
            if (etn.quantity != this.quantity) {
                return false;
            }
            if (!etn.cost.equals((Object)this.cost)) {
                return false;
            }
            if (!etn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch((TaxableNotification)etn);
        }
        return false;
    }
}

